/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.docs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class PrepareDocResourcesTask
extends DefaultTask {
    @Input
    public abstract Property<String> getResourceClasspathJarName();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract ConfigurableFileCollection getResources();

    @OutputDirectory
    public abstract DirectoryProperty getOutputDirectory();

    @Inject
    protected abstract ArchiveOperations getArchiveOperations();

    @Inject
    protected abstract FileOperations getFileOperations();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public void copy() throws IOException {
        String src = (String)this.getResourceClasspathJarName().get();
        File outputDir = (File)this.getOutputDirectory().getAsFile().get();
        File tmpJarFile = new File(this.getTemporaryDir(), src);
        try {
            URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(src);
            if (url != null) {
                try (InputStream input = url.openStream();){
                    Files.copy(input, tmpJarFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
            }
            this.getArchiveOperations().zipTree((Object)tmpJarFile).visit(details -> {
                String relativePath = details.getRelativePath().getPathString();
                if (!relativePath.startsWith("META-INF")) {
                    File target = new File(outputDir, relativePath);
                    if (details.isDirectory()) {
                        this.getFileOperations().mkdir((Object)target);
                    } else {
                        try {
                            Files.copy(details.getFile().toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            });
            this.getFileOperations().copy(spec -> {
                spec.into((Object)outputDir);
                spec.from(new Object[]{this.getResources()});
            });
        }
        catch (Throwable throwable) {
            this.getFileOperations().delete(new Object[]{tmpJarFile});
            throw throwable;
        }
        this.getFileOperations().delete(new Object[]{tmpJarFile});
    }
}

