/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.docs;

import io.micronaut.build.utils.ConsoleUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class ValidateAsciidocOutputTask
extends DefaultTask {
    private static final String UNRESOLVED_DIRECTIVE = "Unresolved directive in";

    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract DirectoryProperty getInputDirectory();

    @Input
    @Optional
    public abstract Property<Boolean> getFailOnError();

    @OutputFile
    public abstract RegularFileProperty getReport();

    @TaskAction
    void validate() throws IOException {
        HashMap errors = new HashMap();
        this.getInputDirectory().getAsFileTree().visit(details -> {
            if (details.getName().endsWith(".html")) {
                try {
                    Files.readAllLines(details.getFile().toPath()).forEach(line -> {
                        if (line.contains(UNRESOLVED_DIRECTIVE)) {
                            errors.computeIfAbsent(details.getName(), k -> new ArrayList()).add(line);
                        }
                    });
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        if (!errors.isEmpty()) {
            try (PrintWriter prn = new PrintWriter(new FileWriter((File)this.getReport().getAsFile().get()));){
                for (Map.Entry entry : errors.entrySet()) {
                    prn.println("In file " + (String)entry.getKey());
                    for (String line : (List)entry.getValue()) {
                        prn.println("    " + line);
                    }
                }
            }
            if (((Boolean)this.getFailOnError().getOrElse((Object)true)).booleanValue()) {
                throw new GradleException("Validation of generated asciidoctor files failed. See the report at " + ConsoleUtils.clickableUrl((File)this.getReport().getAsFile().get()));
            }
        }
    }
}

