/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.docs.props;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class ProcessConfigPropsTask
extends DefaultTask {
    private static final String SEPARATOR = "<<<";
    private static final String ID = "id=\"";
    private static final String ANCHOR_WITH_ID = "<a id=\"";
    private static final String DOUBLE_QUOTE = "\"";

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract ConfigurableFileCollection getInputFiles();

    @OutputDirectory
    public abstract DirectoryProperty getOutputDirectory();

    @Inject
    protected abstract FileOperations getFileOperations();

    @TaskAction
    void process() throws IOException {
        for (File configProperties : this.getInputFiles().getFiles()) {
            if (!configProperties.exists()) continue;
            File individualConfigsPropsFolder = (File)this.getOutputDirectory().getAsFile().get();
            this.getFileOperations().delete(new Object[]{individualConfigsPropsFolder});
            this.getFileOperations().mkdir((Object)individualConfigsPropsFolder);
            ArrayList<String> accumulator = new ArrayList<String>();
            String configurationPropertyName = "";
            for (String line : Files.readAllLines(configProperties.toPath(), StandardCharsets.UTF_8)) {
                if (line.startsWith(ANCHOR_WITH_ID)) {
                    String sub = line.substring(line.indexOf(ID) + ID.length());
                    configurationPropertyName = sub = sub.substring(0, sub.indexOf(DOUBLE_QUOTE));
                }
                if (SEPARATOR.equals(line)) {
                    File outputfile = new File(individualConfigsPropsFolder, configurationPropertyName + ".adoc");
                    try (PrintWriter writer = new PrintWriter(outputfile, StandardCharsets.UTF_8.name());){
                        for (String s : accumulator) {
                            writer.print(s);
                            writer.print('\n');
                        }
                    }
                    accumulator.clear();
                    configurationPropertyName = null;
                    continue;
                }
                accumulator.add(line);
            }
        }
    }
}

