/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.docs.props;

import java.io.File;
import java.io.FileOutputStream;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.Options;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class PublishConfigurationReferenceTask
extends DefaultTask {
    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getPropertyReferenceFile();

    @Input
    public abstract Property<String> getVersion();

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getPageTemplate();

    @Inject
    public abstract ProviderFactory getProviders();

    @OutputFile
    public abstract RegularFileProperty getDestinationFile();

    @TaskAction
    void publishConfigurationReference() {
        File referenceFile = (File)this.getPropertyReferenceFile().getAsFile().get();
        if (referenceFile.exists()) {
            String textPage = (String)this.getProviders().fileContents((Provider)this.getPageTemplate()).getAsText().get();
            textPage = textPage.replace("@projectVersion@", (CharSequence)this.getVersion().get());
            textPage = textPage.replace("@pagetitle@", "Configuration Reference | Micronaut");
            try {
                String html = Asciidoctor.Factory.create().convert((String)this.getProviders().fileContents((Provider)this.getPropertyReferenceFile()).getAsText().get(), Options.builder().build());
                textPage = textPage.replace("@docscontent@", html);
                try (FileOutputStream fos = new FileOutputStream((File)this.getDestinationFile().getAsFile().get());){
                    fos.write(textPage.getBytes(StandardCharsets.UTF_8.name()));
                }
            }
            catch (Exception e) {
                this.getLogger().error("Error raised rendering asciidoc file {}", this.getDestinationFile().getAsFile().get());
            }
        } else {
            this.getLogger().quiet("{} does not exist.", new Object[]{referenceFile});
        }
    }
}

