/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.pom;

public final class PomDependency {
    private final boolean isManaged;
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String scope;

    public PomDependency(boolean isManaged, String groupId, String artifactId, String version, String scope) {
        this.isManaged = isManaged;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.scope = scope;
    }

    public boolean isManaged() {
        return this.isManaged;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getScope() {
        return this.scope;
    }

    public String toString() {
        return this.groupId + ":" + this.artifactId + ":" + this.version + (String)(!this.scope.isEmpty() ? " scope " + this.scope : "");
    }

    public boolean isImport() {
        return "import".equals(this.scope);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PomDependency that = (PomDependency)o;
        if (this.isManaged != that.isManaged) {
            return false;
        }
        if (!this.groupId.equals(that.groupId)) {
            return false;
        }
        if (!this.artifactId.equals(that.artifactId)) {
            return false;
        }
        if (!this.version.equals(that.version)) {
            return false;
        }
        return this.scope.equals(that.scope);
    }

    public int hashCode() {
        int result = this.isManaged ? 1 : 0;
        result = 31 * result + this.groupId.hashCode();
        result = 31 * result + this.artifactId.hashCode();
        result = 31 * result + this.version.hashCode();
        result = 31 * result + this.scope.hashCode();
        return result;
    }
}

