/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.utils;

import io.micronaut.build.utils.GithubApiUtils;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;

public abstract class GitHubApiService
implements BuildService<BuildServiceParameters.None> {
    private static final Logger LOGGER = Logging.getLogger(GitHubApiService.class);
    private final Map<String, byte[]> tags = new HashMap<String, byte[]>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] fetchTagsFromGitHub(String slug) {
        Map<String, byte[]> map = this.tags;
        synchronized (map) {
            return this.tags.computeIfAbsent(slug, s -> GithubApiUtils.fetchTagsFromGitHub(LOGGER, slug));
        }
    }

    public static Provider<GitHubApiService> registerOn(Project project) {
        return project.getGradle().getSharedServices().registerIfAbsent("GitHubService", GitHubApiService.class, spec -> {});
    }
}

