/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.utils;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.gradle.api.Project;
import org.gradle.api.artifacts.VersionCatalogsExtension;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.provider.Provider;

public class VersionHandling {
    private static final List<String> DEFAULT_CATALOGS = Collections.singletonList("libs");

    private static String versionOrDefault(Project project, String alias, List<String> catalogNames, String defaultVersion) {
        String catalogName;
        VersionCatalogsExtension catalogs = (VersionCatalogsExtension)project.getExtensions().findByType(VersionCatalogsExtension.class);
        if (catalogs == null) {
            return VersionHandling.projectProperty(project, alias, defaultVersion);
        }
        Optional<String> version = Optional.empty();
        ArrayDeque<String> deque = new ArrayDeque<String>(catalogNames);
        while ((catalogName = (String)deque.poll()) != null) {
            String currentCatalog = catalogName;
            version = version.or(() -> VersionHandling.findVersionInCatalog(currentCatalog, alias, catalogs));
        }
        return version.orElseGet(() -> VersionHandling.projectProperty(project, alias, defaultVersion));
    }

    private static Optional<String> findVersionInCatalog(String catalogName, String alias, VersionCatalogsExtension catalogs) {
        return catalogs.find(catalogName).flatMap(catalog -> {
            Optional version = catalog.findVersion(alias);
            if (version.isPresent()) {
                return version;
            }
            return catalog.findVersion("managed." + alias);
        }).map(VersionConstraint::getRequiredVersion);
    }

    public static Provider<String> versionProviderOrDefault(Project project, String alias, String defaultVersion) {
        return project.provider(() -> VersionHandling.versionOrDefault(project, alias, DEFAULT_CATALOGS, defaultVersion));
    }

    public static Provider<String> versionProviderOrDefault(Project project, String alias, List<String> catalogNames, String defaultVersion) {
        return project.provider(() -> VersionHandling.versionOrDefault(project, alias, catalogNames, defaultVersion));
    }

    private static String propertyNameFor(String alias) {
        String[] components = alias.split("[.\\-_]");
        String propertyName = IntStream.range(0, components.length).mapToObj(i -> {
            if (i == 0) {
                return components[i];
            }
            String c = components[i];
            return Character.toUpperCase(c.charAt(0)) + c.substring(1).toLowerCase();
        }).collect(Collectors.joining(""));
        return propertyName + "Version";
    }

    private static String projectProperty(Project p, String alias, String defaultVersion) {
        Object projectProp = p.findProperty(VersionHandling.propertyNameFor(alias));
        if (projectProp != null) {
            return String.valueOf(projectProp);
        }
        return defaultVersion;
    }
}

