/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build;

import io.methvin.watcher.DirectoryChangeEvent;
import io.methvin.watcher.DirectoryWatcher;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.util.filter.DependencyFilterUtils;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class MicronautRunMojo
extends AbstractMojo {
    private static final List<String> PHASES_AFTER_COMPILE = Arrays.asList("compile", "process-classes", "generate-test-sources", "process-test-sources", "generate-test-resources", "process-test-resources", "test-compile", "process-test-classes", "test", "prepare-package", "package", "pre-integration-test", "integration-test", "post-integration-test", "verify", "install", "deploy");
    private static final String MAVEN_COMPILER_PLUGIN = "org.apache.maven.plugins:maven-compiler-plugin";
    private static final String MAVEN_RESOURCES_PLUGIN = "org.apache.maven.plugins:maven-resources-plugin";
    private static final String GMAVEN_PLUS_PLUGIN = "org.codehaus.gmavenplus:gmavenplus-plugin";
    private static final String KOTLIN_MAVEN_PLUGIN = "org.jetbrains.kotlin:kotlin-maven-plugin";
    private static final int LAST_COMPILATION_THRESHOLD = 500;
    private final MavenSession mavenSession;
    private final ProjectDependenciesResolver resolver;
    private final ProjectBuilder projectBuilder;
    private final MojoExecutor.ExecutionEnvironment executionEnvironment;
    private final ToolchainManager toolchainManager;
    private final String javaExecutable;
    @Parameter(defaultValue="${project.build.directory}")
    private File targetDirectory;
    @Parameter(defaultValue="${exec.mainClass}")
    private String mainClass;
    @Parameter(property="mn.debug", defaultValue="false")
    private boolean debug;
    @Parameter(property="mn.debug.suspend", defaultValue="false")
    private boolean debugSuspend;
    @Parameter(property="mn.debug.port", defaultValue="5005")
    private int debugPort;
    private MavenProject mavenProject;
    private DirectoryWatcher directoryWatcher;
    private Process process;
    private Path projectRootDirectory;
    private List<Dependency> projectDependencies;
    private String classpath;
    private long lastCompilation;
    private Map<String, Path> sourceDirectories;

    @Inject
    public MicronautRunMojo(MavenProject mavenProject, MavenSession mavenSession, BuildPluginManager pluginManager, ProjectDependenciesResolver resolver, ProjectBuilder projectBuilder, ToolchainManager toolchainManager) {
        this.mavenProject = mavenProject;
        this.mavenSession = mavenSession;
        this.resolver = resolver;
        this.projectBuilder = projectBuilder;
        this.projectRootDirectory = mavenProject.getBasedir().toPath();
        this.toolchainManager = toolchainManager;
        this.executionEnvironment = MojoExecutor.executionEnvironment((MavenProject)mavenProject, (MavenSession)mavenSession, (BuildPluginManager)pluginManager);
        this.javaExecutable = this.findJavaExecutable();
        this.resolveDependencies();
    }

    public void execute() throws MojoExecutionException {
        this.resolveSourceDirectories();
        boolean needsCompilation = this.mavenSession.getGoals().stream().noneMatch(PHASES_AFTER_COMPILE::contains);
        if (needsCompilation) {
            this.compileProject();
        }
        try {
            this.runApplication();
            Thread shutdownHook = new Thread(this::killProcess);
            Runtime.getRuntime().addShutdownHook(shutdownHook);
            ArrayList<Path> pathsToWatch = new ArrayList<Path>(this.sourceDirectories.values());
            pathsToWatch.add(this.projectRootDirectory);
            this.getLog().debug((CharSequence)("pathsToWatch: " + ((Object)pathsToWatch).toString()));
            this.directoryWatcher = DirectoryWatcher.builder().paths(pathsToWatch).listener(this::handleEvent).build();
            this.getLog().debug((CharSequence)"Watching for changes...");
            this.directoryWatcher.watch();
        }
        catch (Exception e) {
            this.getLog().debug((CharSequence)"Exception while watching for changes", (Throwable)e);
            throw new MojoExecutionException("Exception while watching for changes", e);
        }
        finally {
            this.killProcess();
            this.cleanup();
        }
    }

    private void resolveSourceDirectories() {
        this.getLog().debug((CharSequence)"Resolving source directories...");
        AtomicReference lang = new AtomicReference();
        this.sourceDirectories = Stream.of("java", "groovy", "kotlin").peek(lang::set).map(l -> new File(this.mavenProject.getBasedir(), "src/main/" + l)).filter(File::exists).peek(f -> this.getLog().debug((CharSequence)("Found source: " + f.getPath()))).map(File::toPath).collect(Collectors.toMap(path -> (String)lang.get(), Function.identity()));
        if (this.sourceDirectories.isEmpty()) {
            throw new IllegalStateException("Source folders not found for neither Java/Groovy/Kotlin");
        }
    }

    private void handleEvent(DirectoryChangeEvent event) throws IOException {
        Path path = event.path();
        Path parent = path.getParent();
        if (parent.equals(this.projectRootDirectory)) {
            if (path.endsWith("pom.xml")) {
                this.getLog().info((CharSequence)"Detected POM change. Resolving dependencies...");
                this.rebuildMavenProject();
                this.resolveDependencies();
                this.getLog().info((CharSequence)"Finished resolving dependencies. Recompilation is not necessary");
            }
        } else if (this.isChangeInSourceDirectory(parent, path)) {
            this.getLog().info((CharSequence)("Detected change in " + path));
            boolean compiledOk = this.compileProject();
            if (compiledOk) {
                this.runApplication();
            }
        }
    }

    private boolean isChangeInSourceDirectory(Path parent, Path path) {
        return this.sourceDirectories.values().stream().anyMatch(parent::startsWith) && !Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS) && Files.isReadable(path) && System.currentTimeMillis() - this.lastCompilation >= 500L;
    }

    private void cleanup() {
        this.getLog().debug((CharSequence)"Cleaning up");
        try {
            this.directoryWatcher.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void rebuildMavenProject() {
        try {
            MavenProject project;
            ProjectBuildingRequest projectBuildingRequest = this.mavenSession.getProjectBuildingRequest();
            projectBuildingRequest.setResolveDependencies(true);
            ProjectBuildingResult build = this.projectBuilder.build(this.mavenProject.getArtifact(), projectBuildingRequest);
            this.mavenProject = project = build.getProject();
            this.mavenSession.setCurrentProject(project);
        }
        catch (ProjectBuildingException e) {
            this.getLog().warn((CharSequence)"Error while trying to build the Maven project model", (Throwable)e);
        }
    }

    private void resolveDependencies() {
        try {
            DependencyFilter filter = DependencyFilterUtils.classpathFilter((String[])new String[]{"compile", "runtime"});
            RepositorySystemSession session = this.mavenSession.getRepositorySession();
            DefaultDependencyResolutionRequest dependencyResolutionRequest = new DefaultDependencyResolutionRequest(this.mavenProject, session);
            dependencyResolutionRequest.setResolutionFilter(filter);
            DependencyResolutionResult result = this.resolver.resolve((DependencyResolutionRequest)dependencyResolutionRequest);
            this.projectDependencies = result.getDependencies();
            this.buildClasspath();
        }
        catch (DependencyResolutionException e) {
            this.getLog().warn((CharSequence)"Error while trying to resolve dependencies for the current project", (Throwable)e);
        }
    }

    private void buildClasspath() {
        this.classpath = this.projectDependencies.stream().map(dependency -> dependency.getArtifact().getFile().getAbsolutePath()).collect(Collectors.joining(File.pathSeparator));
    }

    private void runApplication() throws IOException {
        String classpathArgument = new File(this.targetDirectory, "classes" + File.pathSeparator).getAbsolutePath() + this.classpath;
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.javaExecutable);
        if (this.debug) {
            String suspend = this.debugSuspend ? "y" : "n";
            args.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=" + suspend + ",address=" + this.debugPort);
        }
        args.add("-classpath");
        args.add(classpathArgument);
        args.add("-XX:TieredStopAtLevel=1");
        args.add("-Dcom.sun.management.jmxremote");
        args.add(this.mainClass);
        this.getLog().debug((CharSequence)("Running " + String.join((CharSequence)" ", args)));
        this.killProcess();
        this.process = new ProcessBuilder(args).inheritIO().directory(this.targetDirectory).start();
    }

    private String findJavaExecutable() {
        Toolchain toolchain = this.toolchainManager.getToolchainFromBuildContext("jdk", this.mavenSession);
        if (toolchain != null) {
            return toolchain.findTool("java");
        }
        File javaBinariesDir = new File(new File(System.getProperty("java.home")), "bin");
        if (Os.isFamily((String)"unix")) {
            return new File(javaBinariesDir, "java").getAbsolutePath();
        }
        if (Os.isFamily((String)"windows")) {
            return new File(javaBinariesDir, "java.exe").getAbsolutePath();
        }
        return "java";
    }

    private boolean compileProject() {
        this.getLog().debug((CharSequence)"Compiling the project");
        try {
            if (this.sourceDirectories.containsKey("groovy")) {
                this.executeGoal(GMAVEN_PLUS_PLUGIN, "addSources");
                this.executeGoal(GMAVEN_PLUS_PLUGIN, "generateStubs");
                this.executeGoal(MAVEN_RESOURCES_PLUGIN, "resources");
                this.executeGoal(MAVEN_COMPILER_PLUGIN, "compile");
                this.executeGoal(GMAVEN_PLUS_PLUGIN, "compile");
                this.executeGoal(GMAVEN_PLUS_PLUGIN, "removeStubs");
                this.lastCompilation = System.currentTimeMillis();
            }
            if (this.sourceDirectories.containsKey("kotlin")) {
                this.executeGoal(KOTLIN_MAVEN_PLUGIN, "kapt");
                this.executeGoal(MAVEN_RESOURCES_PLUGIN, "resources");
                this.executeGoal(KOTLIN_MAVEN_PLUGIN, "compile");
                this.executeGoal(MAVEN_COMPILER_PLUGIN, "compile#java-compile");
                this.lastCompilation = System.currentTimeMillis();
            }
            if (this.sourceDirectories.containsKey("java")) {
                this.executeGoal(MAVEN_RESOURCES_PLUGIN, "resources");
                this.executeGoal(MAVEN_COMPILER_PLUGIN, "compile");
                this.lastCompilation = System.currentTimeMillis();
            }
        }
        catch (MojoExecutionException e) {
            this.getLog().error((CharSequence)"Error while compiling the project: ", (Throwable)e);
            return false;
        }
        return true;
    }

    private void executeGoal(String pluginKey, String goal) throws MojoExecutionException {
        Plugin plugin = this.mavenProject.getPlugin(pluginKey);
        if (plugin != null) {
            Optional<PluginExecution> execution;
            AtomicReference<String> executionId = new AtomicReference<String>(goal);
            if (goal != null && goal.length() > 0 && goal.indexOf(35) > -1) {
                int pos = goal.indexOf(35);
                executionId.set(goal.substring(pos + 1));
                goal = goal.substring(0, pos);
            }
            Xpp3Dom configuration = (execution = plugin.getExecutions().stream().filter(e -> e.getId().equals(executionId.get())).findFirst()).isPresent() ? (Xpp3Dom)execution.get().getConfiguration() : (plugin.getConfiguration() != null ? (Xpp3Dom)plugin.getConfiguration() : MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[0]));
            MojoExecutor.executeMojo((Plugin)plugin, (String)MojoExecutor.goal((String)goal), (Xpp3Dom)configuration, (MojoExecutor.ExecutionEnvironment)this.executionEnvironment);
        }
    }

    private void killProcess() {
        this.getLog().debug((CharSequence)"Stopping the background process");
        if (this.process != null && this.process.isAlive()) {
            this.process.destroy();
            try {
                this.process.waitFor();
            }
            catch (InterruptedException e) {
                this.process.destroyForcibly();
            }
        }
    }
}

