/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.services;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.BuildImageCmd;
import com.github.dockerjava.api.command.BuildImageResultCallback;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.model.BuildResponseItem;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.DockerClientImpl;
import com.github.dockerjava.transport.DockerHttpClient;
import com.github.dockerjava.transport.SSLConfig;
import com.github.dockerjava.zerodep.ZerodepDockerHttpClient;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DockerService {
    private static final Logger LOG = LoggerFactory.getLogger(DockerService.class);
    private final DockerClient dockerClient;
    private final MavenProject mavenProject;

    @Inject
    public DockerService(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
        DefaultDockerClientConfig config = DefaultDockerClientConfig.createDefaultConfigBuilder().build();
        ZerodepDockerHttpClient httpClient = new ZerodepDockerHttpClient.Builder().dockerHost(config.getDockerHost()).sslConfig((SSLConfig)config.getSSLConfig()).build();
        this.dockerClient = DockerClientImpl.getInstance((DockerClientConfig)config, (DockerHttpClient)httpClient);
    }

    public BuildImageCmd buildImageCmd(String dockerfileName) throws IOException {
        return this.dockerClient.buildImageCmd(this.loadDockerfileAsResource(dockerfileName));
    }

    public BuildImageCmd buildImageCmd() {
        return this.dockerClient.buildImageCmd();
    }

    public String buildImage(BuildImageCmd builder) {
        BuildImageResultCallback resultCallback = new BuildImageResultCallback(){

            public void onNext(BuildResponseItem item) {
                super.onNext(item);
                if (item.isErrorIndicated()) {
                    LOG.error(item.getErrorDetail().getMessage());
                } else if (item.getStream() != null) {
                    LOG.info(StringUtils.chomp((String)item.getStream(), (String)System.lineSeparator()));
                }
            }
        };
        return ((BuildImageResultCallback)builder.exec((ResultCallback)resultCallback)).awaitImageId();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File copyFromContainer(String imageId, String containerPath) {
        CreateContainerResponse container = this.dockerClient.createContainerCmd(imageId).exec();
        this.dockerClient.startContainerCmd(container.getId());
        InputStream nativeImage = this.dockerClient.copyArchiveFromContainerCmd(container.getId(), containerPath).exec();
        try (TarArchiveInputStream fin = new TarArchiveInputStream(nativeImage);){
            TarArchiveEntry tarEntry = fin.getNextTarEntry();
            File file2 = new File(this.mavenProject.getBuild().getDirectory(), tarEntry.getName());
            IOUtils.copy((InputStream)fin, (OutputStream)new FileOutputStream(file2));
            File file = file2;
            return file;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public File loadDockerfileAsResource(String name) throws IOException {
        String path = "/dockerfiles/" + name;
        InputStream stream = this.getClass().getResourceAsStream(path);
        if (stream != null) {
            File dockerfile = new File(this.mavenProject.getBuild().getDirectory(), "Dockerfile");
            FileUtils.copyInputStreamToFile((InputStream)stream, (File)dockerfile);
            return dockerfile;
        }
        return null;
    }
}

