/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build;

import com.github.dockerjava.api.command.BuildImageCmd;
import io.micronaut.build.AbstractDockerMojo;
import io.micronaut.build.services.ApplicationConfigurationService;
import io.micronaut.build.services.DockerService;
import io.micronaut.build.services.JibConfigurationService;
import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.io.FileUtils;

@Mojo(name="docker", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class DockerMojo
extends AbstractDockerMojo {
    public static final String DOCKER_PACKAGING = "docker";

    @Inject
    public DockerMojo(MavenProject mavenProject, JibConfigurationService jibConfigurationService, ApplicationConfigurationService applicationConfigurationService, DockerService dockerService) {
        super(mavenProject, jibConfigurationService, applicationConfigurationService, dockerService);
    }

    public void execute() throws MojoExecutionException {
        File dockerfile = new File(this.mavenProject.getBasedir(), "Dockerfile");
        if (dockerfile.exists()) {
            try {
                this.getLog().info((CharSequence)("Using provided Dockerfile: " + dockerfile.getAbsolutePath()));
                this.mavenProject.getProperties().put("jib.skip", "true");
                this.copyDependencies();
                String targetDir = this.mavenProject.getBuild().getDirectory();
                File targetDockerfile = new File(targetDir, dockerfile.getName());
                FileUtils.copyFile((File)dockerfile, (File)targetDockerfile);
                BuildImageCmd buildImageCmd = this.dockerService.buildImageCmd().withDockerfile(targetDockerfile).withTags(this.getTags()).withBaseDirectory(new File(targetDir));
                this.dockerService.buildImage(buildImageCmd);
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        } else {
            this.mavenProject.getProperties().setProperty("jib.from.image", "openjdk:15-alpine");
        }
    }
}

