/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.services;

import io.micronaut.build.services.ExecutorService;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.apache.maven.project.MavenProject;

@Singleton
public class CompilerService {
    private static final String JAVA = "java";
    private static final String GROOVY = "groovy";
    private static final String KOTLIN = "kotlin";
    public static final String MAVEN_COMPILER_PLUGIN = "org.apache.maven.plugins:maven-compiler-plugin";
    public static final String MAVEN_RESOURCES_PLUGIN = "org.apache.maven.plugins:maven-resources-plugin";
    public static final String GMAVEN_PLUS_PLUGIN = "org.codehaus.gmavenplus:gmavenplus-plugin";
    public static final String KOTLIN_MAVEN_PLUGIN = "org.jetbrains.kotlin:kotlin-maven-plugin";
    private static final List<String> PHASES_AFTER_COMPILE = Arrays.asList("compile", "process-classes", "generate-test-sources", "process-test-sources", "generate-test-resources", "process-test-resources", "test-compile", "process-test-classes", "test", "prepare-package", "package", "pre-integration-test", "integration-test", "post-integration-test", "verify", "install", "deploy");
    private final Log log = new SystemStreamLog();
    private final Map<String, Path> sourceDirectories;
    private final MavenProject mavenProject;
    private final MavenSession mavenSession;
    private final ExecutorService executorService;

    @Inject
    public CompilerService(MavenProject mavenProject, MavenSession mavenSession, ExecutorService executorService) {
        this.mavenProject = mavenProject;
        this.mavenSession = mavenSession;
        this.executorService = executorService;
        this.sourceDirectories = this.resolveSourceDirectories();
    }

    public boolean needsCompilation() {
        return this.mavenSession.getGoals().stream().noneMatch(PHASES_AFTER_COMPILE::contains);
    }

    public Optional<Long> compileProject(boolean copyResources) {
        Long lastCompilation;
        block9: {
            lastCompilation = null;
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)"Compiling the project");
            }
            try {
                if (this.sourceDirectories.containsKey(GROOVY)) {
                    this.executorService.executeGoal(GMAVEN_PLUS_PLUGIN, "addSources");
                    this.executorService.executeGoal(GMAVEN_PLUS_PLUGIN, "generateStubs");
                    if (copyResources) {
                        this.executorService.executeGoal(MAVEN_RESOURCES_PLUGIN, "resources");
                    }
                    this.executorService.executeGoal(MAVEN_COMPILER_PLUGIN, "compile");
                    this.executorService.executeGoal(GMAVEN_PLUS_PLUGIN, "compile");
                    this.executorService.executeGoal(GMAVEN_PLUS_PLUGIN, "removeStubs");
                    lastCompilation = System.currentTimeMillis();
                }
                if (this.sourceDirectories.containsKey(KOTLIN)) {
                    this.executorService.executeGoal(KOTLIN_MAVEN_PLUGIN, "kapt");
                    if (copyResources) {
                        this.executorService.executeGoal(MAVEN_RESOURCES_PLUGIN, "resources");
                    }
                    this.executorService.executeGoal(KOTLIN_MAVEN_PLUGIN, "compile");
                    this.executorService.executeGoal(MAVEN_COMPILER_PLUGIN, "compile#java-compile");
                    lastCompilation = System.currentTimeMillis();
                }
                if (this.sourceDirectories.containsKey(JAVA)) {
                    if (copyResources) {
                        this.executorService.executeGoal(MAVEN_RESOURCES_PLUGIN, "resources");
                    }
                    this.executorService.executeGoal(MAVEN_COMPILER_PLUGIN, "compile");
                    lastCompilation = System.currentTimeMillis();
                }
            }
            catch (MojoExecutionException e) {
                if (!this.log.isErrorEnabled()) break block9;
                this.log.error((CharSequence)"Error while compiling the project: ", (Throwable)e);
            }
        }
        return Optional.ofNullable(lastCompilation);
    }

    public Map<String, Path> resolveSourceDirectories() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)"Resolving source directories...");
        }
        AtomicReference lang = new AtomicReference();
        Map<String, Path> sourceDirectories = Stream.of(JAVA, GROOVY, KOTLIN).peek(lang::set).map(l -> new File(this.mavenProject.getBasedir(), "src/main/" + l)).filter(File::exists).peek(f -> {
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("Found source: " + f.getPath()));
            }
        }).map(File::toPath).collect(Collectors.toMap(path -> (String)lang.get(), Function.identity()));
        if (sourceDirectories.isEmpty()) {
            throw new IllegalStateException("Source folders not found for neither Java/Groovy/Kotlin");
        }
        return sourceDirectories;
    }
}

