/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build;

import com.github.dockerjava.api.command.BuildImageCmd;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.api.InvalidImageReferenceException;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import io.micronaut.build.AbstractDockerMojo;
import io.micronaut.build.MicronautRuntime;
import io.micronaut.build.services.ApplicationConfigurationService;
import io.micronaut.build.services.DockerService;
import io.micronaut.build.services.JibConfigurationService;
import io.micronaut.core.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="docker-native", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class DockerNativeMojo
extends AbstractDockerMojo {
    public static final String DOCKER_NATIVE_PACKAGING = "docker-native";
    public static final String GRAALVM_ARGS = "GRAALVM_ARGS";

    @Inject
    public DockerNativeMojo(MavenProject mavenProject, JibConfigurationService jibConfigurationService, ApplicationConfigurationService applicationConfigurationService, DockerService dockerService) {
        super(mavenProject, jibConfigurationService, applicationConfigurationService, dockerService);
    }

    public void execute() throws MojoExecutionException {
        this.checkJavaVersion();
        this.checkGraalVm();
        try {
            this.copyDependencies();
            MicronautRuntime runtime = MicronautRuntime.valueOf(this.micronautRuntime.toUpperCase());
            switch (runtime.getBuildStrategy()) {
                case LAMBDA: {
                    this.buildDockerNativeLambda();
                    break;
                }
                case ORACLE_FUNCTION: {
                    this.buildOracleCloud();
                    break;
                }
                case DEFAULT: {
                    this.buildDockerNative();
                }
            }
        }
        catch (InvalidImageReferenceException iire) {
            String message = "Invalid image reference " + iire.getInvalidReference() + ", perhaps you should check that the reference is formatted correctly according to https://docs.docker.com/engine/reference/commandline/tag/#extended-description\nFor example, slash-separated name components cannot have uppercase letters";
            throw new MojoExecutionException(message);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void checkGraalVm() throws MojoExecutionException {
        String micronautVersion = this.mavenProject.getProperties().getProperty("micronaut.version");
        if (!((List)this.mavenProject.getInjectedProfileIds().get("io.micronaut:micronaut-parent:" + micronautVersion)).contains("graalvm")) {
            String javaVendor = System.getProperty("java.vendor", "");
            if (javaVendor.toLowerCase().contains("graalvm")) {
                throw new MojoExecutionException("The [graalvm] profile was not activated automatically because the native-image component is not installed (or not found in your path). Either activate the profile manually (-Pgraalvm) or install the native-image component (gu install native-image), and try again");
            }
            throw new MojoExecutionException("The [graalvm] profile was not activated automatically because you are not using a GraalVM JDK. Activate the profile manually (-Pgraalvm) and try again");
        }
    }

    private void checkJavaVersion() throws MojoExecutionException {
        if (this.javaVersion().getMajorVersion() > 17) {
            throw new MojoExecutionException("To build native images you must set the Java target byte code level to Java 17 or below");
        }
    }

    private void buildDockerNativeLambda() throws IOException {
        BuildImageCmd buildImageCmd = this.dockerService.buildImageCmd("DockerfileAwsCustomRuntime").withBuildArg("GRAALVM_VERSION", this.graalVmVersion()).withBuildArg("GRAALVM_JVM_VERSION", this.graalVmJvmVersion());
        this.getLog().info((CharSequence)("Using GRAALVM_VERSION: " + this.graalVmVersion()));
        this.getLog().info((CharSequence)("Using GRAALVM_JVM_VERSION: " + this.graalVmJvmVersion()));
        this.getLog().info((CharSequence)("Using CLASS_NAME: " + this.mainClass));
        buildImageCmd.withBuildArg("CLASS_NAME", this.mainClass);
        String graalVmBuildArgs = this.getGraalVmBuildArgs();
        if (graalVmBuildArgs != null && !graalVmBuildArgs.isEmpty()) {
            this.getLog().info((CharSequence)("Using GRAALVM_ARGS: " + graalVmBuildArgs));
            buildImageCmd = buildImageCmd.withBuildArg(GRAALVM_ARGS, graalVmBuildArgs);
        }
        String imageId = this.dockerService.buildImage(buildImageCmd);
        File functionZip = this.dockerService.copyFromContainer(imageId, "/function/function.zip");
        this.getLog().info((CharSequence)("AWS Lambda Custom Runtime ZIP: " + functionZip.getPath()));
    }

    private void buildDockerNative() throws IOException, InvalidImageReferenceException {
        String dockerfileName = "DockerfileNative";
        if (this.staticNativeImage.booleanValue()) {
            this.getLog().info((CharSequence)"Generating a static native image");
            dockerfileName = "DockerfileNativeStatic";
        } else if (this.baseImageRun.contains("distroless")) {
            this.getLog().info((CharSequence)"Generating a mostly static native image");
            dockerfileName = "DockerfileNativeDistroless";
        }
        this.buildDockerfile(dockerfileName, true);
    }

    private void buildOracleCloud() throws IOException, InvalidImageReferenceException {
        this.buildDockerfile("DockerfileNativeOracleCloud", false);
    }

    private void buildDockerfile(String dockerfileName, boolean passClassName) throws IOException, InvalidImageReferenceException {
        Set<String> tags = this.getTags();
        for (String tag : tags) {
            ImageReference.parse((String)tag);
        }
        String from = this.getFrom();
        String port = this.getPort();
        this.getLog().info((CharSequence)("Exposing port: " + port));
        File dockerfile = this.dockerService.loadDockerfileAsResource(dockerfileName);
        if (this.appArguments != null && !this.appArguments.isEmpty()) {
            this.getLog().info((CharSequence)("Using application arguments: " + this.appArguments));
            Files.asCharSink((File)dockerfile, (Charset)Charset.defaultCharset(), (FileWriteMode[])new FileWriteMode[]{FileWriteMode.APPEND}).write((CharSequence)(System.lineSeparator() + this.getCmd()));
        }
        BuildImageCmd buildImageCmd = this.dockerService.buildImageCmd().withDockerfile(dockerfile).withTags(this.getTags()).withBuildArg("BASE_IMAGE", from).withBuildArg("PORT", port);
        this.getLog().info((CharSequence)("Using BASE_IMAGE: " + from));
        if (StringUtils.isNotEmpty((CharSequence)this.baseImageRun) && !this.staticNativeImage.booleanValue()) {
            this.getLog().info((CharSequence)("Using BASE_IMAGE_RUN: " + this.baseImageRun));
            buildImageCmd.withBuildArg("BASE_IMAGE_RUN", this.baseImageRun);
        }
        if (this.baseImageRun.contains("alpine-glibc")) {
            buildImageCmd.withBuildArg("EXTRA_CMD", "apk update && apk add libstdc++");
        } else {
            buildImageCmd.withBuildArg("EXTRA_CMD", "");
        }
        if (passClassName) {
            this.getLog().info((CharSequence)("Using CLASS_NAME: " + this.mainClass));
            buildImageCmd = buildImageCmd.withBuildArg("CLASS_NAME", this.mainClass);
        }
        String graalVmBuildArgs = this.getGraalVmBuildArgs();
        if (this.baseImageRun.contains("distroless") && !graalVmBuildArgs.contains("-H:+StaticExecutableWithDynamicLibC")) {
            graalVmBuildArgs = "-H:+StaticExecutableWithDynamicLibC " + graalVmBuildArgs;
        }
        if (graalVmBuildArgs != null && !graalVmBuildArgs.isEmpty()) {
            this.getLog().info((CharSequence)("Using GRAALVM_ARGS: " + graalVmBuildArgs));
            buildImageCmd = buildImageCmd.withBuildArg(GRAALVM_ARGS, graalVmBuildArgs);
        }
        this.dockerService.buildImage(buildImageCmd);
    }
}

