/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build;

import io.methvin.watcher.DirectoryChangeEvent;
import io.methvin.watcher.DirectoryWatcher;
import io.micronaut.build.services.CompilerService;
import io.micronaut.build.services.ExecutorService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.eclipse.aether.graph.Dependency;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
@Execute(phase=LifecyclePhase.PROCESS_CLASSES)
public class RunMojo
extends AbstractMojo {
    public static final String MN_APP_ARGS = "mn.appArgs";
    public static final String EXEC_MAIN_CLASS = "${exec.mainClass}";
    private static final int LAST_COMPILATION_THRESHOLD = 500;
    private static final String JAVA = "java";
    private static final List<String> DEFAULT_EXCLUDES = new ArrayList<String>();
    private final MavenSession mavenSession;
    private final ProjectDependenciesResolver resolver;
    private final ProjectBuilder projectBuilder;
    private final ToolchainManager toolchainManager;
    private final String javaExecutable;
    private final CompilerService compilerService;
    private final Path projectRootDirectory;
    @Parameter(defaultValue="${project.build.directory}")
    private File targetDirectory;
    @Parameter(defaultValue="${exec.mainClass}", required=true)
    private String mainClass;
    @Parameter(property="mn.debug", defaultValue="false")
    private boolean debug;
    @Parameter(property="mn.debug.suspend", defaultValue="false")
    private boolean debugSuspend;
    @Parameter(property="mn.debug.port", defaultValue="5005")
    private int debugPort;
    @Parameter(property="mn.debug.host", defaultValue="127.0.0.1")
    private String debugHost;
    @Parameter
    private List<FileSet> watches;
    @Parameter(property="mn.jvmArgs")
    private String jvmArguments;
    @Parameter(property="mn.appArgs")
    private String appArguments;
    @Parameter(property="mn.watch", defaultValue="true")
    private boolean watchForChanges;
    private MavenProject mavenProject;
    private DirectoryWatcher directoryWatcher;
    private Process process;
    private List<Dependency> projectDependencies;
    private String classpath;
    private int classpathHash;
    private long lastCompilation;
    private Map<String, Path> sourceDirectories;

    @Inject
    public RunMojo(MavenProject mavenProject, MavenSession mavenSession, BuildPluginManager pluginManager, ProjectDependenciesResolver resolver, ProjectBuilder projectBuilder, ToolchainManager toolchainManager, CompilerService compilerService, ExecutorService executorService) {
        this.mavenProject = mavenProject;
        this.mavenSession = mavenSession;
        this.resolver = resolver;
        this.projectBuilder = projectBuilder;
        this.projectRootDirectory = mavenProject.getBasedir().toPath();
        this.toolchainManager = toolchainManager;
        this.compilerService = compilerService;
        this.javaExecutable = this.findJavaExecutable();
        this.resolveDependencies();
        this.classpathHash = this.classpath.hashCode();
    }

    public void execute() throws MojoExecutionException {
        this.sourceDirectories = this.compilerService.resolveSourceDirectories();
        try {
            this.runApplication();
            Thread shutdownHook = new Thread(this::killProcess);
            Runtime.getRuntime().addShutdownHook(shutdownHook);
            if (this.watchForChanges) {
                ArrayList<Path> pathsToWatch = new ArrayList<Path>(this.sourceDirectories.values());
                pathsToWatch.add(this.projectRootDirectory);
                if (this.watches != null && !this.watches.isEmpty()) {
                    for (FileSet fs : this.watches) {
                        File directory = new File(fs.getDirectory());
                        if (directory.exists()) {
                            pathsToWatch.add(directory.toPath());
                            if (fs.getIncludes() != null && !fs.getIncludes().isEmpty() || fs.getExcludes() != null && !fs.getExcludes().isEmpty()) continue;
                            fs.addInclude("**/*");
                            continue;
                        }
                        if (!this.getLog().isWarnEnabled()) continue;
                        this.getLog().warn((CharSequence)("The specified directory to watch doesn't exist: " + directory.getPath()));
                    }
                }
                this.directoryWatcher = DirectoryWatcher.builder().paths(pathsToWatch).listener(this::handleEvent).build();
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)"Watching for changes...");
                }
                this.directoryWatcher.watch();
            } else if (this.process != null && this.process.isAlive()) {
                this.process.waitFor();
            }
        }
        catch (Exception e) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"Exception while watching for changes", (Throwable)e);
            }
            throw new MojoExecutionException("Exception while watching for changes", e);
        }
        finally {
            this.killProcess();
            this.cleanup();
        }
    }

    private void handleEvent(DirectoryChangeEvent event) throws IOException {
        Path path = event.path();
        Path parent = path.getParent();
        if (parent.equals(this.projectRootDirectory)) {
            if (path.endsWith("pom.xml") && this.rebuildMavenProject() && this.resolveDependencies() && this.classpathHasChanged()) {
                if (this.getLog().isInfoEnabled()) {
                    this.getLog().info((CharSequence)"Detected POM dependencies change. Restarting application");
                }
                try {
                    this.runApplication();
                }
                catch (Exception e) {
                    this.getLog().error((CharSequence)("Unable to run application: " + e.getMessage()), (Throwable)e);
                }
            }
        } else if (this.matches(path)) {
            boolean compiledOk;
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("Detected change in " + this.projectRootDirectory.relativize(path).toString()));
            }
            if (compiledOk = this.compileProject()) {
                try {
                    this.runApplication();
                }
                catch (Exception e) {
                    this.getLog().error((CharSequence)("Unable to run application: " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    private boolean matches(Path path) {
        if (this.isDefaultExcluded(path) || Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS) || !Files.isReadable(path) || this.hasBeenCompiledRecently()) {
            return false;
        }
        boolean matches = this.sourceDirectories.values().stream().anyMatch(path.getParent()::startsWith);
        String relativePath = this.projectRootDirectory.relativize(path).toString();
        if (this.getLog().isDebugEnabled()) {
            String belongs = matches ? "belongs" : "does not belong";
            this.getLog().debug((CharSequence)("Path [" + relativePath + "] " + belongs + " to a source directory"));
        }
        if (this.watches != null && !this.watches.isEmpty()) {
            File directory;
            if (!matches) {
                for (FileSet fileSet : this.watches) {
                    if (fileSet.getIncludes() != null && !fileSet.getIncludes().isEmpty() && (directory = new File(fileSet.getDirectory())).exists() && path.getParent().startsWith(directory.getAbsolutePath())) {
                        for (String includePattern : fileSet.getIncludes()) {
                            if (!DirectoryScanner.match((String)includePattern, (String)path.toString()) && !new File(directory, includePattern).toPath().toAbsolutePath().equals(path)) continue;
                            matches = true;
                            if (!this.getLog().isDebugEnabled()) break;
                            this.getLog().debug((CharSequence)("Path [" + relativePath + "] matched the include pattern [" + includePattern + "] of the directory [" + fileSet.getDirectory() + "]"));
                            break;
                        }
                    }
                    if (!matches) continue;
                    break;
                }
            }
            if (matches) {
                for (FileSet fileSet : this.watches) {
                    if (fileSet.getExcludes() != null && !fileSet.getExcludes().isEmpty() && (directory = new File(fileSet.getDirectory())).exists() && path.getParent().startsWith(directory.getAbsolutePath())) {
                        for (String excludePattern : fileSet.getExcludes()) {
                            if (!DirectoryScanner.match((String)excludePattern, (String)path.toString()) && !new File(directory, excludePattern).toPath().toAbsolutePath().equals(path)) continue;
                            matches = false;
                            if (!this.getLog().isDebugEnabled()) break;
                            this.getLog().debug((CharSequence)("Path [" + relativePath + "] matched the exclude pattern [" + excludePattern + "] of the directory [" + fileSet.getDirectory() + "]"));
                            break;
                        }
                    }
                    if (matches) continue;
                    break;
                }
            }
        }
        return matches;
    }

    private boolean isDefaultExcluded(Path path) {
        return path.startsWith(this.targetDirectory.getAbsolutePath()) || DEFAULT_EXCLUDES.stream().anyMatch(excludePattern -> DirectoryScanner.match((String)excludePattern, (String)path.toString()));
    }

    private boolean hasBeenCompiledRecently() {
        return System.currentTimeMillis() - this.lastCompilation < 500L;
    }

    private void cleanup() {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"Cleaning up");
        }
        try {
            this.directoryWatcher.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean rebuildMavenProject() {
        boolean success;
        block2: {
            success = true;
            try {
                MavenProject project;
                ProjectBuildingRequest projectBuildingRequest = this.mavenSession.getProjectBuildingRequest();
                projectBuildingRequest.setResolveDependencies(true);
                ProjectBuildingResult build = this.projectBuilder.build(this.mavenProject.getArtifact(), projectBuildingRequest);
                this.mavenProject = project = build.getProject();
                this.mavenSession.setCurrentProject(project);
            }
            catch (ProjectBuildingException e) {
                success = false;
                if (!this.getLog().isWarnEnabled()) break block2;
                this.getLog().warn((CharSequence)"Error while trying to build the Maven project model", (Throwable)e);
            }
        }
        return success;
    }

    private boolean resolveDependencies() {
        List<Dependency> dependencies = this.compilerService.resolveDependencies("compile", "runtime");
        if (dependencies.isEmpty()) {
            return false;
        }
        this.projectDependencies = dependencies;
        this.classpath = this.compilerService.buildClasspath(this.projectDependencies);
        return true;
    }

    private boolean classpathHasChanged() {
        int oldClasspathHash = this.classpathHash;
        this.classpathHash = this.classpath.hashCode();
        return oldClasspathHash != this.classpathHash;
    }

    private void runApplication() throws Exception {
        String[] strings;
        String classpathArgument = new File(this.targetDirectory, "classes" + File.pathSeparator).getAbsolutePath() + this.classpath;
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.javaExecutable);
        if (this.debug) {
            String suspend = this.debugSuspend ? "y" : "n";
            args.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=" + suspend + ",address=" + this.debugHost + ":" + this.debugPort);
        }
        if (this.jvmArguments != null && !this.jvmArguments.isEmpty()) {
            strings = CommandLineUtils.translateCommandline((String)this.jvmArguments);
            args.addAll(Arrays.asList(strings));
        }
        if (!this.mavenSession.getUserProperties().isEmpty()) {
            this.mavenSession.getUserProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> args.add("-D" + k + "=" + v)));
        }
        args.add("-classpath");
        args.add(classpathArgument);
        args.add("-XX:TieredStopAtLevel=1");
        args.add("-Dcom.sun.management.jmxremote");
        args.add(this.mainClass);
        if (this.appArguments != null && !this.appArguments.isEmpty()) {
            strings = CommandLineUtils.translateCommandline((String)this.appArguments);
            args.addAll(Arrays.asList(strings));
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Running " + String.join((CharSequence)" ", args)));
        }
        this.killProcess();
        this.process = new ProcessBuilder(args).inheritIO().directory(this.targetDirectory).start();
    }

    private String findJavaExecutable() {
        String executable;
        Toolchain toolchain = this.toolchainManager.getToolchainFromBuildContext("jdk", this.mavenSession);
        if (toolchain != null) {
            executable = toolchain.findTool(JAVA);
        } else {
            File javaBinariesDir = new File(new File(System.getProperty("java.home")), "bin");
            executable = Os.isFamily((String)"unix") ? new File(javaBinariesDir, JAVA).getAbsolutePath() : (Os.isFamily((String)"windows") ? new File(javaBinariesDir, "java.exe").getAbsolutePath() : JAVA);
        }
        return executable;
    }

    private boolean compileProject() {
        Optional<Long> lastCompilation = this.compilerService.compileProject(true);
        lastCompilation.ifPresent(lc -> {
            this.lastCompilation = lc;
        });
        return lastCompilation.isPresent();
    }

    private void killProcess() {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"Stopping the background process");
        }
        if (this.process != null && this.process.isAlive()) {
            this.process.destroy();
            try {
                this.process.waitFor();
            }
            catch (InterruptedException e) {
                this.process.destroyForcibly();
            }
        }
    }

    static {
        Collections.addAll(DEFAULT_EXCLUDES, DirectoryScanner.DEFAULTEXCLUDES);
        Collections.addAll(DEFAULT_EXCLUDES, "**/.idea/**");
    }
}

