/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.aot;

import io.micronaut.build.Packaging;
import io.micronaut.build.aot.AotRuntime;
import io.micronaut.build.services.CompilerService;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.resolution.DependencyResolutionException;

public abstract class AbstractMicronautAotMojo
extends AbstractMojo {
    protected final CompilerService compilerService;
    protected final MavenProject mavenProject;
    protected final MavenSession mavenSession;
    protected final RepositorySystem repositorySystem;
    @Parameter(property="micronaut.aot.runtime", required=true, defaultValue="jit")
    protected String runtime;
    @Parameter(property="micronaut.aot.version", required=true)
    protected String micronautAotVersion;
    @Parameter(property="micronaut.aot.enabled", defaultValue="false")
    protected boolean enabled;

    public AbstractMicronautAotMojo(CompilerService compilerService, MavenProject mavenProject, MavenSession mavenSession, RepositorySystem repositorySystem) {
        this.compilerService = compilerService;
        this.mavenProject = mavenProject;
        this.mavenSession = mavenSession;
        this.repositorySystem = repositorySystem;
    }

    abstract void onSuccess(File var1) throws MojoExecutionException;

    protected final File getBaseOutputDirectory() {
        File targetDirectory = new File(this.mavenProject.getBuild().getDirectory(), "aot");
        return new File(targetDirectory, this.runtime);
    }

    protected final File outputFile(String name) {
        return new File(this.getBaseOutputDirectory(), name);
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.enabled) {
            return;
        }
        this.validateRuntime();
        this.getLog().info((CharSequence)("Running Micronaut AOT " + this.micronautAotVersion + " " + this.getName()));
        try {
            File baseOutputDirectory = this.getBaseOutputDirectory();
            this.clean(baseOutputDirectory);
            this.doExecute();
            this.onSuccess(baseOutputDirectory);
        }
        catch (IOException | DependencyResolutionException e) {
            throw new MojoExecutionException("Unable to generate AOT optimizations", (Exception)e);
        }
    }

    private void clean(File baseOutputDirectory) throws IOException {
        if (baseOutputDirectory.exists()) {
            this.getLog().debug((CharSequence)("Deleting " + baseOutputDirectory.getAbsolutePath()));
            FileUtils.deleteDirectory((File)baseOutputDirectory);
        }
        baseOutputDirectory.mkdirs();
    }

    private void validateRuntime() {
        Packaging packaging = Packaging.of(this.mavenProject.getPackaging());
        AotRuntime aotRuntime = AotRuntime.valueOf(this.runtime.toUpperCase());
        switch (packaging) {
            case JAR: 
            case DOCKER: {
                if (aotRuntime == AotRuntime.JIT) break;
                this.warnRuntimeMismatchAndSetCorrectValue(AotRuntime.JIT);
                break;
            }
            case NATIVE_IMAGE: 
            case DOCKER_NATIVE: {
                if (aotRuntime == AotRuntime.NATIVE) break;
                this.warnRuntimeMismatchAndSetCorrectValue(AotRuntime.NATIVE);
            }
        }
    }

    private void warnRuntimeMismatchAndSetCorrectValue(AotRuntime correctRuntime) {
        String correctRuntimeString = correctRuntime.name().toLowerCase();
        this.getLog().warn((CharSequence)("Packaging is set to [" + this.mavenProject.getPackaging() + "], but Micronaut AOT runtime is set to [" + this.runtime + "]. Setting AOT runtime to: [" + correctRuntimeString + "]"));
        this.runtime = correctRuntimeString;
    }

    protected abstract void doExecute() throws DependencyResolutionException, MojoExecutionException;

    abstract String getName();
}

