/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.aot;

import io.micronaut.aot.std.sourcegen.KnownMissingTypesSourceGenerator;
import io.micronaut.build.aot.AbstractMicronautAotCliMojo;
import io.micronaut.build.aot.Constants;
import io.micronaut.build.services.CompilerService;
import io.micronaut.build.services.ExecutorService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;

@Mojo(name="aot-analysis", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class AotAnalysisMojo
extends AbstractMicronautAotCliMojo {
    public static final String NAME = "aot-analysis";
    public static final String AOT_PROPERTIES_FILE_NAME = "aot.properties";
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File baseDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    private File outputDirectory;
    @Parameter(property="micronaut.aot.config", defaultValue="aot.properties")
    private File configFile;

    @Inject
    public AotAnalysisMojo(CompilerService compilerService, ExecutorService executorService, MavenProject mavenProject, MavenSession mavenSession, RepositorySystem repositorySystem) {
        super(compilerService, executorService, mavenProject, mavenSession, repositorySystem);
    }

    @Override
    protected List<String> getExtraArgs() throws MojoExecutionException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("--output");
        File generated = this.outputFile("generated");
        args.add(generated.getAbsolutePath());
        File effectiveConfigFile = this.writeEffectiveConfigFile();
        args.add("--config");
        args.add(effectiveConfigFile.getAbsolutePath());
        return args;
    }

    private File writeEffectiveConfigFile() throws MojoExecutionException {
        File userProvidedFile = this.configFile == null ? new File(this.baseDirectory, AOT_PROPERTIES_FILE_NAME) : this.configFile;
        Properties props = new Properties();
        if (userProvidedFile.exists()) {
            try (FileInputStream in = new FileInputStream(userProvidedFile);){
                this.getLog().info((CharSequence)("Using AOT configuration file: " + this.configFile.getAbsolutePath()));
                props.load(in);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to parse configuration file", (Exception)e);
            }
        }
        if (!props.containsKey(KnownMissingTypesSourceGenerator.OPTION.key())) {
            props.put(KnownMissingTypesSourceGenerator.OPTION.key(), String.join((CharSequence)",", Constants.TYPES_TO_CHECK));
        }
        if (!props.containsKey("service.types")) {
            props.put("service.types", String.join((CharSequence)",", Constants.SERVICE_TYPES));
        }
        File effectiveConfig = this.outputFile("effective-aot.properties");
        try (FileOutputStream out = new FileOutputStream(effectiveConfig);){
            props.store(out, "Effective AOT configuration");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to parse configuration file", (Exception)e);
        }
        return effectiveConfig;
    }

    @Override
    protected void onSuccess(File outputDir) throws MojoExecutionException {
        Path generated = outputDir.toPath().resolve("generated");
        Path generatedClasses = generated.resolve("classes");
        try {
            FileUtils.copyDirectory((File)generatedClasses.toFile(), (File)this.outputDirectory);
            try (Stream<String> linesStream = Files.lines(generated.resolve("logs").resolve("resource-filter.txt"));){
                linesStream.forEach(toRemove -> {
                    block2: {
                        try {
                            Files.delete(this.outputDirectory.toPath().resolve((String)toRemove));
                            this.getLog().debug((CharSequence)("Removed " + toRemove));
                        }
                        catch (IOException e) {
                            if (e instanceof NoSuchFileException) break block2;
                            this.getLog().warn((CharSequence)("Error while deleting " + toRemove), (Throwable)e);
                        }
                    }
                });
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error when copying the Micronaut AOT generated classes into the target directory", (Exception)e);
        }
    }

    @Override
    String getName() {
        return NAME;
    }
}

