/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.services;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Singleton
public class ExecutorService {
    private final MojoExecutor.ExecutionEnvironment executionEnvironment;
    private final MavenProject mavenProject;

    @Inject
    public ExecutorService(MavenProject mavenProject, MavenSession mavenSession, BuildPluginManager pluginManager) {
        this.executionEnvironment = MojoExecutor.executionEnvironment((MavenProject)mavenProject, (MavenSession)mavenSession, (BuildPluginManager)pluginManager);
        this.mavenProject = mavenProject;
    }

    public void executeGoal(String pluginKey, String goal) throws MojoExecutionException {
        AtomicReference<String> executionId;
        Plugin plugin = this.mavenProject.getPlugin(pluginKey);
        if (plugin != null) {
            executionId = new AtomicReference<String>(goal);
            if (goal != null && goal.length() > 0 && goal.indexOf(35) > -1) {
                int pos = goal.indexOf(35);
                executionId.set(goal.substring(pos + 1));
                goal = goal.substring(0, pos);
            }
        } else {
            throw new MojoExecutionException("Plugin not found: " + pluginKey);
        }
        Optional<PluginExecution> execution = plugin.getExecutions().stream().filter(e -> e.getId().equals(executionId.get())).findFirst();
        Xpp3Dom configuration = execution.isPresent() ? (Xpp3Dom)execution.get().getConfiguration() : (plugin.getConfiguration() != null ? (Xpp3Dom)plugin.getConfiguration() : MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[0]));
        MojoExecutor.executeMojo((Plugin)plugin, (String)MojoExecutor.goal((String)goal), (Xpp3Dom)configuration, (MojoExecutor.ExecutionEnvironment)this.executionEnvironment);
    }

    public void executeGoal(String pluginGroup, String pluginArtifact, String pluginVersion, String goal, Xpp3Dom configuration) throws MojoExecutionException {
        Plugin plugin = MojoExecutor.plugin((String)pluginGroup, (String)pluginArtifact, (String)pluginVersion);
        MojoExecutor.executeMojo((Plugin)plugin, (String)MojoExecutor.goal((String)goal), (Xpp3Dom)configuration, (MojoExecutor.ExecutionEnvironment)this.executionEnvironment);
    }
}

