/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build;

import io.micronaut.build.AbstractDockerMojo;
import io.micronaut.build.MicronautRuntime;
import io.micronaut.build.Packaging;
import io.micronaut.build.jib.JibMicronautExtension;
import io.micronaut.build.services.ApplicationConfigurationService;
import io.micronaut.build.services.DockerService;
import io.micronaut.build.services.JibConfigurationService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="dockerfile", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class DockerfileMojo
extends AbstractDockerMojo {
    public static final String DOCKERFILE = "Dockerfile";
    public static final String DOCKERFILE_AWS_CUSTOM_RUNTIME = "DockerfileAwsCustomRuntime";
    public static final String DOCKERFILE_NATIVE = "DockerfileNative";
    public static final String DOCKERFILE_NATIVE_DISTROLESS = "DockerfileNativeDistroless";
    public static final String DOCKERFILE_NATIVE_STATIC = "DockerfileNativeStatic";
    public static final String DOCKERFILE_NATIVE_ORACLE_CLOUD = "DockerfileNativeOracleCloud";

    @Inject
    public DockerfileMojo(MavenProject mavenProject, DockerService dockerService, JibConfigurationService jibConfigurationService, ApplicationConfigurationService applicationConfigurationService) {
        super(mavenProject, jibConfigurationService, applicationConfigurationService, dockerService);
    }

    public void execute() throws MojoExecutionException {
        MicronautRuntime runtime = MicronautRuntime.valueOf(this.micronautRuntime.toUpperCase());
        Packaging packaging = Packaging.of(this.mavenProject.getPackaging());
        try {
            Optional<File> dockerfile;
            this.copyDependencies();
            switch (packaging) {
                case DOCKER_NATIVE: {
                    dockerfile = this.buildDockerfileNative(runtime);
                    break;
                }
                case DOCKER: {
                    dockerfile = this.buildDockerfile(runtime);
                    break;
                }
                default: {
                    throw new MojoExecutionException("Packaging is set to [" + (Object)((Object)packaging) + "]. To generate a Dockerfile, set the packaging to either [" + Packaging.DOCKER.id() + "] or [" + Packaging.DOCKER_NATIVE.id() + "]");
                }
            }
            dockerfile.ifPresent(file -> this.getLog().info((CharSequence)("Dockerfile written to: " + file.getAbsolutePath())));
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private Optional<File> buildDockerfile(MicronautRuntime runtime) throws IOException {
        File dockerfile;
        switch (runtime.getBuildStrategy()) {
            case ORACLE_FUNCTION: {
                dockerfile = this.dockerService.loadDockerfileAsResource("DockerfileOracleCloud");
                this.processOracleFunctionDockerfile(dockerfile);
                break;
            }
            default: {
                dockerfile = this.dockerService.loadDockerfileAsResource(DOCKERFILE);
                this.processDockerfile(dockerfile);
            }
        }
        return Optional.ofNullable(dockerfile);
    }

    private void processOracleFunctionDockerfile(File dockerfile) throws IOException {
        if (dockerfile != null) {
            List<String> allLines = Files.readAllLines(dockerfile.toPath());
            allLines.add(0, allLines.remove(0) + JibMicronautExtension.determineProjectFnVersion());
            String entrypoint = JibMicronautExtension.buildProjectFnEntrypoint().stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(", "));
            allLines.add("ENTRYPOINT [" + entrypoint + "]");
            Files.write(dockerfile.toPath(), allLines, new OpenOption[0]);
        }
    }

    private Optional<File> buildDockerfileNative(MicronautRuntime runtime) throws IOException {
        File dockerfile;
        switch (runtime.getBuildStrategy()) {
            case LAMBDA: {
                dockerfile = this.dockerService.loadDockerfileAsResource(DOCKERFILE_AWS_CUSTOM_RUNTIME);
                break;
            }
            case ORACLE_FUNCTION: {
                dockerfile = this.dockerService.loadDockerfileAsResource(DOCKERFILE_NATIVE_ORACLE_CLOUD);
                break;
            }
            default: {
                String dockerfileName = DOCKERFILE_NATIVE;
                if (this.staticNativeImage.booleanValue()) {
                    this.getLog().info((CharSequence)"Generating a static native image");
                    dockerfileName = DOCKERFILE_NATIVE_STATIC;
                } else if (this.baseImageRun.contains("distroless")) {
                    this.getLog().info((CharSequence)"Generating a mostly static native image");
                    dockerfileName = DOCKERFILE_NATIVE_DISTROLESS;
                }
                dockerfile = this.dockerService.loadDockerfileAsResource(dockerfileName);
            }
        }
        this.processDockerfile(dockerfile);
        return Optional.ofNullable(dockerfile);
    }

    private void processDockerfile(File dockerfile) throws IOException {
        if (dockerfile != null) {
            List<String> allLines = Files.readAllLines(dockerfile.toPath());
            ArrayList<String> result = new ArrayList<String>();
            for (String line : allLines) {
                if (line.startsWith("ARG")) continue;
                if (line.contains("BASE_IMAGE_RUN")) {
                    result.add(line.replace("${BASE_IMAGE_RUN}", this.baseImageRun));
                    continue;
                }
                if (line.contains("BASE_IMAGE")) {
                    result.add(line.replace("${BASE_IMAGE}", this.getFrom()));
                    continue;
                }
                if (line.contains("EXTRA_CMD")) {
                    if (this.baseImageRun.contains("alpine-glibc")) {
                        result.add("RUN apk update && apk add libstdc++");
                        continue;
                    }
                    result.add("");
                    continue;
                }
                if (line.contains("GRAALVM_") || line.contains("CLASS_NAME")) {
                    String graalVmBuildArgs = this.getGraalVmBuildArgs();
                    if (this.baseImageRun.contains("distroless") && !graalVmBuildArgs.contains("-H:+StaticExecutableWithDynamicLibC")) {
                        graalVmBuildArgs = "-H:+StaticExecutableWithDynamicLibC " + graalVmBuildArgs;
                    }
                    result.add(line.replace("${GRAALVM_VERSION}", this.graalVmVersion()).replace("${GRAALVM_JVM_VERSION}", this.graalVmJvmVersion()).replace("${GRAALVM_ARCH}", this.graalVmArch()).replace("${GRAALVM_ARGS}", graalVmBuildArgs).replace("${CLASS_NAME}", this.mainClass));
                    continue;
                }
                if (line.contains("PORT")) {
                    result.add(line.replace("${PORT}", this.getPort()));
                    continue;
                }
                result.add(line);
            }
            if (this.appArguments != null && !this.appArguments.isEmpty()) {
                this.getLog().info((CharSequence)("Using application arguments: " + this.appArguments));
                result.add(this.getCmd());
            }
            Files.write(dockerfile.toPath(), result, new OpenOption[0]);
        }
    }
}

