/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build;

import java.io.File;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.util.Os;

public final class MojoUtils {
    private static final String JAVA = "java";

    private MojoUtils() {
    }

    public static String findJavaExecutable(ToolchainManager toolchainManager, MavenSession mavenSession) {
        String executable;
        Toolchain toolchain = toolchainManager.getToolchainFromBuildContext("jdk", mavenSession);
        if (toolchain != null) {
            executable = toolchain.findTool(JAVA);
        } else {
            File javaBinariesDir = new File(new File(System.getProperty("java.home")), "bin");
            executable = Os.isFamily((String)"unix") ? new File(javaBinariesDir, JAVA).getAbsolutePath() : (Os.isFamily((String)"windows") ? new File(javaBinariesDir, "java.exe").getAbsolutePath() : JAVA);
        }
        return executable;
    }
}

