/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.services;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.BuildImageCmd;
import com.github.dockerjava.api.command.BuildImageResultCallback;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.PushImageCmd;
import com.github.dockerjava.api.model.BuildResponseItem;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.DockerClientImpl;
import com.github.dockerjava.transport.DockerHttpClient;
import com.github.dockerjava.transport.SSLConfig;
import com.github.dockerjava.zerodep.ZerodepDockerHttpClient;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DockerService {
    private static final Logger LOG = LoggerFactory.getLogger(DockerService.class);
    private final DockerClient dockerClient;
    private final MavenProject mavenProject;

    @Inject
    public DockerService(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
        DefaultDockerClientConfig config = DefaultDockerClientConfig.createDefaultConfigBuilder().build();
        ZerodepDockerHttpClient httpClient = new ZerodepDockerHttpClient.Builder().dockerHost(config.getDockerHost()).sslConfig((SSLConfig)config.getSSLConfig()).build();
        this.dockerClient = DockerClientImpl.getInstance((DockerClientConfig)config, (DockerHttpClient)httpClient);
    }

    public BuildImageCmd buildImageCmd(String dockerfileName) throws IOException {
        return this.dockerClient.buildImageCmd(this.loadDockerfileAsResource(dockerfileName));
    }

    public BuildImageCmd buildImageCmd() {
        return this.dockerClient.buildImageCmd();
    }

    public String buildImage(BuildImageCmd builder) {
        BuildImageResultCallback resultCallback = new BuildImageResultCallback(){

            public void onNext(BuildResponseItem item) {
                super.onNext(item);
                if (item.isErrorIndicated() && item.getErrorDetail() != null) {
                    LOG.error(item.getErrorDetail().getMessage());
                } else if (item.getStream() != null) {
                    String msg = StringUtils.removeEnd((String)item.getStream(), (String)System.lineSeparator());
                    LOG.info(msg);
                }
            }
        };
        return ((BuildImageResultCallback)builder.exec((ResultCallback)resultCallback)).awaitImageId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public File copyFromContainer(String imageId, String containerPath) {
        CreateContainerCmd containerCmd = this.dockerClient.createContainerCmd(imageId);
        CreateContainerResponse container = containerCmd.exec();
        this.dockerClient.startContainerCmd(container.getId());
        InputStream nativeImage = this.dockerClient.copyArchiveFromContainerCmd(container.getId(), containerPath).exec();
        try {
            File file;
            Throwable throwable;
            TarArchiveInputStream fin;
            block18: {
                block19: {
                    fin = new TarArchiveInputStream(nativeImage);
                    throwable = null;
                    TarArchiveEntry tarEntry = fin.getNextTarEntry();
                    File file2 = new File(this.mavenProject.getBuild().getDirectory(), tarEntry.getName());
                    String canonicalDestinationPath = file2.getCanonicalPath();
                    if (!canonicalDestinationPath.startsWith(this.mavenProject.getBuild().getDirectory())) {
                        throw new IOException("Entry is outside of the target directory");
                    }
                    IOUtils.copy((InputStream)fin, (OutputStream)Files.newOutputStream(file2.toPath(), new OpenOption[0]));
                    file = file2;
                    if (fin == null) break block18;
                    if (throwable == null) break block19;
                    try {
                        fin.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                fin.close();
            }
            return file;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (fin != null) {
                            if (throwable != null) {
                                try {
                                    fin.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                fin.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (IOException e) {
                    LOG.error("Failed to copy file from container", (Throwable)e);
                }
            }
        }
        finally {
            containerCmd.close();
        }
        return null;
    }

    public File loadDockerfileAsResource(String name) throws IOException {
        String path = "/dockerfiles/" + name;
        InputStream stream = this.getClass().getResourceAsStream(path);
        if (stream != null) {
            File dockerfile = new File(this.mavenProject.getBuild().getDirectory(), "Dockerfile");
            FileUtils.copyInputStreamToFile((InputStream)stream, (File)dockerfile);
            return dockerfile;
        }
        return null;
    }

    public PushImageCmd pushImageCmd(String imageName) {
        return this.dockerClient.pushImageCmd(imageName);
    }
}

