/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.testresources;

import io.micronaut.build.MojoUtils;
import io.micronaut.build.services.DependencyResolutionService;
import io.micronaut.build.testresources.AbstractTestResourcesMojo;
import io.micronaut.testresources.buildtools.MavenDependency;
import io.micronaut.testresources.buildtools.ServerFactory;
import io.micronaut.testresources.buildtools.ServerUtils;
import io.micronaut.testresources.buildtools.TestResourcesClasspath;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.ToolchainManager;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.resolution.DependencyResolutionException;

@Mojo(name="start-testresources-service", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class StartTestResourcesServerMojo
extends AbstractTestResourcesMojo {
    public static final String NAME = "start-testresources-service";
    private static final String DEFAULT_CLASSPATH_INFERENCE = "true";
    private static final String DEFAULT_CLIENT_TIMEOUT = "60";
    private static final String TEST_RESOURCES_PROPERTIES = "test-resources.properties";
    private static final String PORT_FILE_NAME = "test-resources-port.txt";
    @Parameter(property="micronaut.test.resources.version", required=true)
    private String testResourcesVersion;
    @Parameter(defaultValue="true")
    private Boolean classpathInference = Boolean.valueOf("true");
    @Parameter
    private List<Dependency> testResourcesDependencies;
    @Parameter(property="micronaut.test.resources.port")
    private Integer explicitPort;
    @Parameter(property="micronaut.test.resources.client-timeout", defaultValue="60")
    private Integer clientTimeout = Integer.valueOf("60");
    private final MavenProject mavenProject;
    private final MavenSession mavenSession;
    private final DependencyResolutionService dependencyResolutionService;
    private final ToolchainManager toolchainManager;

    @Inject
    public StartTestResourcesServerMojo(MavenProject mavenProject, MavenSession mavenSession, DependencyResolutionService dependencyResolutionService, ToolchainManager toolchainManager) {
        this.mavenProject = mavenProject;
        this.mavenSession = mavenSession;
        this.dependencyResolutionService = dependencyResolutionService;
        this.toolchainManager = toolchainManager;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.testResourcesEnabled) {
            return;
        }
        try {
            this.doExecute();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to start test resources server", e);
        }
    }

    private void doExecute() throws DependencyResolutionException, IOException {
        String accessToken = UUID.randomUUID().toString();
        Path buildDir = this.buildDirectory.toPath();
        Path serverSettingsDirectory = this.getServerSettingsDirectory();
        final AtomicBoolean serverStarted = new AtomicBoolean(false);
        ServerUtils.startOrConnectToExistingServer((Integer)this.explicitPort, (Path)buildDir.resolve(PORT_FILE_NAME), (Path)serverSettingsDirectory, (String)accessToken, this.resolveServerClasspath(), (Integer)this.clientTimeout, (ServerFactory)new ServerFactory(){
            Process process;

            public void startServer(ServerUtils.ProcessParameters processParameters) throws IOException {
                StartTestResourcesServerMojo.this.getLog().info((CharSequence)"Starting Micronaut Test Resources service");
                String javaBin = MojoUtils.findJavaExecutable(StartTestResourcesServerMojo.this.toolchainManager, StartTestResourcesServerMojo.this.mavenSession);
                ArrayList<String> cli = new ArrayList<String>();
                cli.add(javaBin);
                cli.addAll(processParameters.getJvmArguments());
                processParameters.getSystemProperties().forEach((key, value) -> cli.add("-D" + key + "=" + value));
                cli.add("-cp");
                cli.add(processParameters.getClasspath().stream().map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator)));
                cli.add(processParameters.getMainClass());
                cli.addAll(processParameters.getArguments());
                ProcessBuilder builder = new ProcessBuilder(cli);
                this.process = builder.inheritIO().start();
                serverStarted.set(true);
            }

            public void waitFor(Duration duration) throws InterruptedException {
                if (this.process != null) {
                    this.process.waitFor(duration.toMillis(), TimeUnit.MILLISECONDS);
                }
            }
        });
        if (this.keepAlive.booleanValue()) {
            this.getLog().info((CharSequence)"Micronaut Test Resources service is started in the background. To stop it, run the following command: 'mvn mn:stop-testresources-service'");
        }
        if (!serverStarted.get()) {
            Path keepalive = this.getKeepAliveFile();
            Files.write(keepalive, DEFAULT_CLASSPATH_INFERENCE.getBytes(), new OpenOption[0]);
        }
        this.copyServerSettingsToClasspath(buildDir, serverSettingsDirectory);
    }

    private void copyServerSettingsToClasspath(Path buildDir, Path serverSettingsDirectory) throws IOException {
        Path testClassesDir = buildDir.resolve("test-classes");
        if (!Files.exists(testClassesDir, new LinkOption[0])) {
            Files.createDirectories(testClassesDir, new FileAttribute[0]);
        }
        Files.copy(serverSettingsDirectory.resolve(TEST_RESOURCES_PROPERTIES), testClassesDir.resolve(TEST_RESOURCES_PROPERTIES), StandardCopyOption.REPLACE_EXISTING);
    }

    private List<File> resolveServerClasspath() throws DependencyResolutionException {
        Stream<Artifact> clientDependencies = Stream.of(DependencyResolutionService.testResourcesModuleToAetherArtifact("client", this.testResourcesVersion));
        List<Object> applicationDependencies = Collections.emptyList();
        if (this.classpathInference.booleanValue()) {
            applicationDependencies = this.getApplicationDependencies();
        }
        Stream<Artifact> serverDependencies = TestResourcesClasspath.inferTestResourcesClasspath(applicationDependencies, (String)this.testResourcesVersion).stream().map(DependencyResolutionService::testResourcesDependencyToAetherArtifact);
        List<Object> extraDependencies = this.testResourcesDependencies != null ? this.testResourcesDependencies : Collections.emptyList();
        Stream<Artifact> extraDependenciesStream = extraDependencies.stream().map(DependencyResolutionService::mavenDependencyToAetherArtifact);
        Stream<Artifact> artifacts = Stream.concat(Stream.concat(clientDependencies, serverDependencies), extraDependenciesStream);
        return DependencyResolutionService.toClasspathFiles(this.dependencyResolutionService.artifactResultsFor(artifacts, true));
    }

    private List<MavenDependency> getApplicationDependencies() {
        return this.mavenProject.getDependencies().stream().map(DependencyResolutionService::mavenDependencyToTestResourcesDependency).collect(Collectors.toList());
    }
}

