/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.testresources;

import io.micronaut.testresources.buildtools.ServerSettings;
import io.micronaut.testresources.buildtools.ServerUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Optional;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class StopTestResourcesHelper {
    private final boolean enabled;
    private final boolean keepAlive;
    private final boolean shared;
    private final Log log;
    private final File buildDirectory;

    public StopTestResourcesHelper(boolean enabled, boolean keepAlive, boolean shared, Log log, File buildDirectory) {
        this.enabled = enabled;
        this.keepAlive = keepAlive;
        this.shared = shared;
        this.log = log;
        this.buildDirectory = buildDirectory;
    }

    public void stopTestResources() throws MojoExecutionException {
        if (!this.enabled || Boolean.TRUE.equals(this.keepAlive)) {
            return;
        }
        if (Files.exists(this.getKeepAliveFile(), new LinkOption[0])) {
            try {
                Files.delete(this.getKeepAliveFile());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to delete keepalive file", (Exception)e);
            }
            return;
        }
        try {
            Optional optionalServerSettings = ServerUtils.readServerSettings((Path)this.getServerSettingsDirectory());
            if (optionalServerSettings.isPresent() && ServerUtils.isServerStarted((int)((ServerSettings)optionalServerSettings.get()).getPort())) {
                this.log.info((CharSequence)"Shutting down Micronaut Test Resources service");
                this.doStop();
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to stop test resources server", e);
        }
    }

    private void doStop() throws IOException {
        Path settingsDirectory = this.getServerSettingsDirectory();
        ServerUtils.stopServer((Path)settingsDirectory);
        Files.walkFileTree(settingsDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return super.visitFile(file, attrs);
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return super.postVisitDirectory(dir, exc);
            }
        });
    }

    private Path getServerSettingsDirectory() {
        if (this.shared) {
            return ServerUtils.getDefaultSharedSettingsPath();
        }
        return this.serverSettingsDirectoryOf(this.buildDirectory.toPath());
    }

    private Path getKeepAliveFile() {
        return this.getServerSettingsDirectory().resolve("keepalive");
    }

    private Path serverSettingsDirectoryOf(Path buildDir) {
        return buildDir.resolve("../.micronaut/test-resources");
    }
}

