/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.testresources;

import io.micronaut.build.testresources.StopTestResourcesHelper;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.monitor.logging.DefaultLog;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class TestResourcesLifecycleExtension
extends AbstractMavenLifecycleParticipant {
    private static final String EXPLICIT_START_SERVICE_GOAL_NAME = "mn:start-testresources-service";
    private static final String EXPLICIT_STOP_SERVICE_GOAL_NAME = "mn:stop-testresources-service";
    private final Map<MavenProject, ExpressionEvaluator> perProjectEvaluator = new ConcurrentHashMap<MavenProject, ExpressionEvaluator>();

    public void afterProjectsRead(MavenSession session) {
        session.getAllProjects().forEach(currentProject -> {
            Build build = currentProject.getBuild();
            TestResourcesLifecycleExtension.withPlugin(build, "io.micronaut.build:micronaut-maven-plugin", plugin -> {
                Xpp3Dom configuration = (Xpp3Dom)plugin.getConfiguration();
                ExpressionEvaluator evaluator = this.perProjectEvaluator.computeIfAbsent((MavenProject)currentProject, mavenProject -> this.initEvaluator((MavenProject)currentProject, session));
                boolean enabled = this.isEnabled(evaluator);
                if (enabled) {
                    List goals;
                    if (configuration == null) {
                        configuration = new Xpp3Dom("configuration");
                        plugin.setConfiguration((Object)configuration);
                    }
                    if ((goals = session.getGoals()).stream().anyMatch(EXPLICIT_START_SERVICE_GOAL_NAME::equals)) {
                        Xpp3Dom flag = new Xpp3Dom("keepAlive");
                        configuration.addChild(flag);
                        flag.setValue("true");
                    }
                    Dependency clientDependency = new Dependency();
                    clientDependency.setGroupId("io.micronaut.testresources");
                    clientDependency.setArtifactId("micronaut-test-resources-client");
                    clientDependency.setVersion(String.valueOf(currentProject.getProperties().get("micronaut.test.resources.version")));
                    clientDependency.setScope("test");
                    currentProject.getDependencies().add(clientDependency);
                }
            });
        });
    }

    public void afterSessionEnd(MavenSession session) {
        if (session.getGoals().stream().noneMatch(s -> s.equals(EXPLICIT_START_SERVICE_GOAL_NAME) || s.equals(EXPLICIT_STOP_SERVICE_GOAL_NAME))) {
            session.getAllProjects().forEach(currentProject -> {
                Build build = currentProject.getBuild();
                TestResourcesLifecycleExtension.withPlugin(build, "io.micronaut.build:micronaut-maven-plugin", plugin -> {
                    ExpressionEvaluator evaluator = this.perProjectEvaluator.computeIfAbsent((MavenProject)currentProject, mavenProject -> this.initEvaluator((MavenProject)currentProject, session));
                    boolean enabled = this.isEnabled(evaluator);
                    boolean keepAlive = this.isKeepAlive(evaluator);
                    boolean shared = this.isShared(evaluator);
                    DefaultLog log = new DefaultLog((Logger)new ConsoleLogger());
                    File buildDirectory = new File(build.getDirectory());
                    StopTestResourcesHelper helper = new StopTestResourcesHelper(enabled, keepAlive, shared, (Log)log, buildDirectory);
                    try {
                        helper.stopTestResources();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            });
        }
    }

    private boolean isShared(ExpressionEvaluator evaluator) {
        return this.evaluateBooleanProperty(evaluator, "micronaut.test.resources.shared");
    }

    private boolean isKeepAlive(ExpressionEvaluator evaluator) {
        return this.evaluateBooleanProperty(evaluator, "keepAlive");
    }

    private boolean isEnabled(ExpressionEvaluator evaluator) {
        return this.evaluateBooleanProperty(evaluator, "micronaut.test.resources.enabled");
    }

    private boolean evaluateBooleanProperty(ExpressionEvaluator evaluator, String property) {
        try {
            Object result = evaluator.evaluate("${" + property + "}");
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            if (result instanceof String && (result.equals(Boolean.TRUE.toString()) || result.equals(Boolean.FALSE.toString()))) {
                return Boolean.parseBoolean((String)result);
            }
        }
        catch (ExpressionEvaluationException e) {
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExpressionEvaluator initEvaluator(MavenProject currentProject, MavenSession session) {
        PluginParameterExpressionEvaluator evaluator;
        Plugin thisPlugin = currentProject.getPlugin("io.micronaut.build:micronaut-maven-plugin");
        MojoExecution execution = new MojoExecution(thisPlugin, null, null);
        MavenProject actualCurrentProject = session.getCurrentProject();
        Map<MavenProject, ExpressionEvaluator> map = this.perProjectEvaluator;
        synchronized (map) {
            session.setCurrentProject(currentProject);
            evaluator = new PluginParameterExpressionEvaluator(session, execution);
            session.setCurrentProject(actualCurrentProject);
        }
        return evaluator;
    }

    private static void withPlugin(Build build, String groupIdArtifactId, Consumer<? super Plugin> consumer) {
        build.getPlugins().stream().filter(p -> groupIdArtifactId.equals(p.getGroupId() + ":" + p.getArtifactId())).findFirst().ifPresent(consumer);
    }
}

