/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.testresources;

import io.micronaut.build.MojoUtils;
import io.micronaut.build.services.DependencyResolutionService;
import io.micronaut.testresources.buildtools.MavenDependency;
import io.micronaut.testresources.buildtools.ServerFactory;
import io.micronaut.testresources.buildtools.ServerSettings;
import io.micronaut.testresources.buildtools.ServerUtils;
import io.micronaut.testresources.buildtools.TestResourcesClasspath;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.ToolchainManager;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.resolution.DependencyResolutionException;

public class TestResourcesHelper {
    private static final String TEST_RESOURCES_PROPERTIES = "test-resources.properties";
    private static final String PORT_FILE_NAME = "test-resources-port.txt";
    private final boolean enabled;
    private final boolean keepAlive;
    private final boolean shared;
    private final File buildDirectory;
    private final Log log;
    private Integer explicitPort;
    private Integer clientTimeout;
    private MavenProject mavenProject;
    private MavenSession mavenSession;
    private DependencyResolutionService dependencyResolutionService;
    private ToolchainManager toolchainManager;
    private String testResourcesVersion;
    private boolean classpathInference;
    private List<Dependency> testResourcesDependencies;
    private String sharedServerNamespace;

    public TestResourcesHelper(boolean enabled, boolean keepAlive, boolean shared, File buildDirectory, Integer explicitPort, Integer clientTimeout, MavenProject mavenProject, MavenSession mavenSession, DependencyResolutionService dependencyResolutionService, ToolchainManager toolchainManager, String testResourcesVersion, boolean classpathInference, List<Dependency> testResourcesDependencies, String sharedServerNamespace) {
        this(enabled, keepAlive, shared, buildDirectory);
        this.explicitPort = explicitPort;
        this.clientTimeout = clientTimeout;
        this.mavenProject = mavenProject;
        this.mavenSession = mavenSession;
        this.dependencyResolutionService = dependencyResolutionService;
        this.toolchainManager = toolchainManager;
        this.testResourcesVersion = testResourcesVersion;
        this.classpathInference = classpathInference;
        this.testResourcesDependencies = testResourcesDependencies;
        this.sharedServerNamespace = sharedServerNamespace;
    }

    public TestResourcesHelper(boolean enabled, boolean keepAlive, boolean shared, File buildDirectory) {
        this.enabled = enabled;
        this.keepAlive = keepAlive;
        this.shared = shared;
        this.buildDirectory = buildDirectory;
        this.log = new SystemStreamLog();
    }

    public void start() throws MojoExecutionException {
        if (!this.enabled) {
            return;
        }
        try {
            this.doStart();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to start test resources server", e);
        }
    }

    private void doStart() throws DependencyResolutionException, IOException {
        if (this.shared) {
            if (this.sharedServerNamespace != null) {
                this.log.info((CharSequence)("Test Resources is configured in shared mode with the namespace: " + this.sharedServerNamespace));
            } else {
                this.log.info((CharSequence)"Test Resources is configured in shared mode");
            }
        }
        String accessToken = UUID.randomUUID().toString();
        Path buildDir = this.buildDirectory.toPath();
        Path serverSettingsDirectory = this.getServerSettingsDirectory();
        final AtomicBoolean serverStarted = new AtomicBoolean(false);
        ServerUtils.startOrConnectToExistingServer((Integer)this.explicitPort, (Path)buildDir.resolve(PORT_FILE_NAME), (Path)serverSettingsDirectory, (String)accessToken, this.resolveServerClasspath(), (Integer)this.clientTimeout, (ServerFactory)new ServerFactory(){
            Process process;

            public void startServer(ServerUtils.ProcessParameters processParameters) throws IOException {
                TestResourcesHelper.this.log.info((CharSequence)"Starting Micronaut Test Resources service");
                String javaBin = MojoUtils.findJavaExecutable(TestResourcesHelper.this.toolchainManager, TestResourcesHelper.this.mavenSession);
                ArrayList<String> cli = new ArrayList<String>();
                cli.add(javaBin);
                cli.addAll(processParameters.getJvmArguments());
                processParameters.getSystemProperties().forEach((key, value) -> cli.add("-D" + key + "=" + value));
                cli.add("-cp");
                cli.add(processParameters.getClasspath().stream().map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator)));
                cli.add(processParameters.getMainClass());
                cli.addAll(processParameters.getArguments());
                ProcessBuilder builder = new ProcessBuilder(cli);
                this.process = builder.inheritIO().start();
                serverStarted.set(true);
            }

            public void waitFor(Duration duration) throws InterruptedException {
                if (this.process != null) {
                    this.process.waitFor(duration.toMillis(), TimeUnit.MILLISECONDS);
                }
            }
        });
        if (this.keepAlive) {
            this.log.info((CharSequence)"Micronaut Test Resources service is started in the background. To stop it, run the following command: 'mvn mn:stop-testresources-service'");
        }
        if (!serverStarted.get()) {
            Path keepalive = this.getKeepAliveFile();
            Files.write(keepalive, "true".getBytes(), new OpenOption[0]);
        }
        this.copyServerSettingsToClasspath(buildDir, serverSettingsDirectory);
    }

    private void copyServerSettingsToClasspath(Path buildDir, Path serverSettingsDirectory) throws IOException {
        Path testClassesDir = buildDir.resolve("test-classes");
        if (!Files.exists(testClassesDir, new LinkOption[0])) {
            Files.createDirectories(testClassesDir, new FileAttribute[0]);
        }
        Files.copy(serverSettingsDirectory.resolve(TEST_RESOURCES_PROPERTIES), testClassesDir.resolve(TEST_RESOURCES_PROPERTIES), StandardCopyOption.REPLACE_EXISTING);
    }

    private List<File> resolveServerClasspath() throws DependencyResolutionException {
        Stream<Artifact> clientDependencies = Stream.of(DependencyResolutionService.testResourcesModuleToAetherArtifact("client", this.testResourcesVersion));
        List<Object> applicationDependencies = Collections.emptyList();
        if (this.classpathInference) {
            applicationDependencies = this.getApplicationDependencies();
        }
        Stream<Artifact> serverDependencies = TestResourcesClasspath.inferTestResourcesClasspath(applicationDependencies, (String)this.testResourcesVersion).stream().map(DependencyResolutionService::testResourcesDependencyToAetherArtifact);
        List<Object> extraDependencies = this.testResourcesDependencies != null ? this.testResourcesDependencies : Collections.emptyList();
        Stream<Artifact> extraDependenciesStream = extraDependencies.stream().map(DependencyResolutionService::mavenDependencyToAetherArtifact);
        Stream<Artifact> artifacts = Stream.concat(Stream.concat(clientDependencies, serverDependencies), extraDependenciesStream);
        return DependencyResolutionService.toClasspathFiles(this.dependencyResolutionService.artifactResultsFor(artifacts, true));
    }

    private List<MavenDependency> getApplicationDependencies() {
        return this.mavenProject.getDependencies().stream().map(DependencyResolutionService::mavenDependencyToTestResourcesDependency).collect(Collectors.toList());
    }

    public void stop() throws MojoExecutionException {
        if (!this.enabled || Boolean.TRUE.equals(this.keepAlive)) {
            return;
        }
        if (Files.exists(this.getKeepAliveFile(), new LinkOption[0])) {
            try {
                Files.delete(this.getKeepAliveFile());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to delete keepalive file", (Exception)e);
            }
            return;
        }
        try {
            Optional optionalServerSettings = ServerUtils.readServerSettings((Path)this.getServerSettingsDirectory());
            if (optionalServerSettings.isPresent() && ServerUtils.isServerStarted((int)((ServerSettings)optionalServerSettings.get()).getPort())) {
                this.log.info((CharSequence)"Shutting down Micronaut Test Resources service");
                this.doStop();
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to stop test resources server", e);
        }
    }

    private void doStop() throws IOException {
        Path settingsDirectory = this.getServerSettingsDirectory();
        ServerUtils.stopServer((Path)settingsDirectory);
        Files.walkFileTree(settingsDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return super.visitFile(file, attrs);
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return super.postVisitDirectory(dir, exc);
            }
        });
    }

    private Path getServerSettingsDirectory() {
        if (this.shared) {
            return ServerUtils.getDefaultSharedSettingsPath((String)this.sharedServerNamespace);
        }
        return this.serverSettingsDirectoryOf(this.buildDirectory.toPath());
    }

    private Path getKeepAliveFile() {
        return this.getServerSettingsDirectory().resolve("keepalive");
    }

    private Path serverSettingsDirectoryOf(Path buildDir) {
        return buildDir.resolve("../.micronaut/test-resources");
    }

    public void setSharedServerNamespace(String sharedServerNamespace) {
        this.sharedServerNamespace = sharedServerNamespace;
    }
}

