/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.resources.ResourcesMojo;

@Mojo(name="graalvm-resources")
public class GraalVMResourcesMojo
extends ResourcesMojo {
    public static final String GRAALVM_RESOURCES = "graalvm-resources";
    private static final String META_INF = "META-INF";
    private static final String RESOURCES = "resources";
    private static final String PATTERN = "pattern";
    private static final String RESOURCE_CONFIG_JSON = "resource-config.json";
    private static final List<String> EXCLUDED_META_INF_DIRECTORIES = Arrays.asList("native-image", "services");
    private final ObjectWriter writer = new ObjectMapper().writer((PrettyPrinter)new DefaultPrettyPrinter());
    @Parameter(property="micronaut.native-image.skip-resources", defaultValue="false")
    private Boolean nativeImageSkipResources;

    public void execute() throws MojoExecutionException {
        if (Boolean.TRUE.equals(this.nativeImageSkipResources)) {
            this.getLog().info((CharSequence)"Skipping generation of resource-config.json");
            return;
        }
        HashSet<String> resourcesToAdd = new HashSet<String>();
        for (Resource resource : this.getResources()) {
            resourcesToAdd.addAll(this.findResourceFiles(Paths.get(resource.getDirectory(), new String[0]).toFile()));
        }
        Path metaInfPath = this.getOutputDirectory().toPath().resolve(META_INF);
        resourcesToAdd.addAll(this.findResourceFiles(metaInfPath.toFile(), Collections.singletonList(META_INF)));
        Path nativeImagePath = this.buildNativeImagePath();
        Path graalVMResourcesPath = metaInfPath.resolve(nativeImagePath).toAbsolutePath();
        HashMap json = new HashMap();
        List resourceList = resourcesToAdd.stream().map(this::mapToGraalResource).collect(Collectors.toList());
        json.put(RESOURCES, resourceList);
        try {
            Files.createDirectories(graalVMResourcesPath, new FileAttribute[0]);
            File resourceConfigFile = graalVMResourcesPath.resolve(RESOURCE_CONFIG_JSON).toFile();
            this.getLog().info((CharSequence)("Generating " + resourceConfigFile.getAbsolutePath()));
            this.writer.writeValue(resourceConfigFile, json);
        }
        catch (IOException e) {
            throw new MojoExecutionException("There was an error generating GraalVM resource-config.json file", (Exception)e);
        }
    }

    private Set<String> findResourceFiles(File folder) {
        return this.findResourceFiles(folder, null);
    }

    private Set<String> findResourceFiles(File folder, List<String> filePath) {
        File[] files;
        HashSet<String> resourceFiles = new HashSet<String>();
        if (filePath == null) {
            filePath = new ArrayList<String>();
        }
        if (folder.exists() && (files = folder.listFiles()) != null) {
            boolean isMetaInfDirectory = folder.getName().equals(META_INF);
            for (File element : files) {
                boolean isExcludedDirectory = EXCLUDED_META_INF_DIRECTORIES.contains(element.getName());
                if (isMetaInfDirectory && isExcludedDirectory) continue;
                if (element.isDirectory()) {
                    ArrayList<String> paths = new ArrayList<String>(filePath);
                    paths.add(element.getName());
                    resourceFiles.addAll(this.findResourceFiles(element, paths));
                    continue;
                }
                String joinedDirectories = String.join((CharSequence)"/", filePath);
                String elementName = joinedDirectories.isEmpty() ? element.getName() : joinedDirectories + "/" + element.getName();
                resourceFiles.add(elementName);
            }
        }
        return resourceFiles;
    }

    private Path buildNativeImagePath() {
        String group = this.project.getGroupId();
        String module = this.project.getArtifactId();
        return Paths.get("native-image", group, module);
    }

    private Map<String, String> mapToGraalResource(String resourceName) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (resourceName.contains("*")) {
            result.put(PATTERN, resourceName);
        } else {
            result.put(PATTERN, "\\Q" + resourceName + "\\E");
        }
        return result;
    }
}

