/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.jib;

import com.google.cloud.tools.jib.api.buildplan.AbsoluteUnixPath;
import com.google.cloud.tools.jib.api.buildplan.ContainerBuildPlan;
import com.google.cloud.tools.jib.api.buildplan.FileEntriesLayer;
import com.google.cloud.tools.jib.api.buildplan.FileEntry;
import com.google.cloud.tools.jib.api.buildplan.LayerObject;
import com.google.cloud.tools.jib.api.buildplan.Port;
import com.google.cloud.tools.jib.buildplan.UnixPathParser;
import com.google.cloud.tools.jib.maven.extension.JibMavenPluginExtension;
import com.google.cloud.tools.jib.maven.extension.MavenData;
import com.google.cloud.tools.jib.plugins.extension.ExtensionLogger;
import io.micronaut.build.MicronautRuntime;
import io.micronaut.build.services.ApplicationConfigurationService;
import io.micronaut.build.services.JibConfigurationService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class JibMicronautExtension
implements JibMavenPluginExtension<Void> {
    public static final String DEFAULT_BASE_IMAGE = "openjdk:17-alpine";

    public Optional<Class<Void>> getExtraConfigType() {
        return Optional.empty();
    }

    public ContainerBuildPlan extendContainerBuildPlan(ContainerBuildPlan buildPlan, Map<String, String> properties, Optional<Void> extraConfig, MavenData mavenData, ExtensionLogger logger) {
        ContainerBuildPlan.Builder builder = buildPlan.toBuilder();
        MicronautRuntime runtime = MicronautRuntime.valueOf(mavenData.getMavenProject().getProperties().getProperty("micronaut.runtime", "none").toUpperCase());
        JibConfigurationService jibConfigurationService = new JibConfigurationService(mavenData.getMavenProject());
        String from = jibConfigurationService.getFromImage().orElse(DEFAULT_BASE_IMAGE);
        builder.setBaseImage(from);
        ApplicationConfigurationService applicationConfigurationService = new ApplicationConfigurationService(mavenData.getMavenProject());
        try {
            int port = Integer.parseInt(applicationConfigurationService.getServerPort());
            if (port > 0) {
                logger.log(ExtensionLogger.LogLevel.LIFECYCLE, "Exposing port: " + port);
                builder.addExposedPort(Port.tcp((int)port));
            }
        }
        catch (NumberFormatException e) {
            logger.log(ExtensionLogger.LogLevel.LIFECYCLE, "Dynamically resolved port present. Ensure the port is correctly exposed in the <container> configuration. See https://github.com/GoogleContainerTools/jib/tree/master/jib-maven-plugin#example for an example.");
        }
        switch (runtime.getBuildStrategy()) {
            case ORACLE_FUNCTION: {
                List originalLayers = buildPlan.getLayers();
                builder.setLayers(Collections.emptyList());
                for (LayerObject layer : originalLayers) {
                    builder.addLayer(this.remapLayer(layer));
                }
                List<String> cmd = jibConfigurationService.getArgs();
                if (cmd.isEmpty()) {
                    cmd = Collections.singletonList("io.micronaut.oraclecloud.function.http.HttpFunction::handleRequest");
                }
                String projectFnVersion = JibMicronautExtension.determineProjectFnVersion(System.getProperty("java.version"));
                builder.setBaseImage("fnproject/fn-java-fdk:" + projectFnVersion).setWorkingDirectory(AbsoluteUnixPath.get((String)jibConfigurationService.getWorkingDirectory().orElse("/function"))).setEntrypoint(JibMicronautExtension.buildProjectFnEntrypoint(projectFnVersion)).setCmd(cmd);
                break;
            }
            case LAMBDA: {
                List entrypoint = buildPlan.getEntrypoint();
                Objects.requireNonNull(entrypoint).set(entrypoint.size() - 1, "io.micronaut.function.aws.runtime.MicronautLambdaRuntime");
                builder.setEntrypoint(entrypoint);
                break;
            }
        }
        return builder.build();
    }

    public static List<String> buildProjectFnEntrypoint(String projectFnVersion) {
        ArrayList<String> entrypoint = new ArrayList<String>(9);
        if ("latest".equals(projectFnVersion)) {
            entrypoint.add("/usr/java/latest/bin/java");
            entrypoint.add("-XX:+UnlockExperimentalVMOptions");
            entrypoint.add("-XX:+UseCGroupMemoryLimitForHeap");
            entrypoint.add("-XX:-UsePerfData");
            entrypoint.add("-XX:MaxRAMFraction=2");
            entrypoint.add("-XX:+UseSerialGC");
            entrypoint.add("-Xshare:on");
            entrypoint.add("-Djava.library.path=/function/runtime/lib");
            entrypoint.add("-cp");
            entrypoint.add("/function/app/classes:/function/app/libs/*:/function/app/resources:/function/runtime/*");
            entrypoint.add("com.fnproject.fn.runtime.EntryPoint");
        } else {
            entrypoint.add("/usr/java/latest/bin/java");
            entrypoint.add("-XX:-UsePerfData");
            entrypoint.add("-XX:+UseSerialGC");
            entrypoint.add("-Xshare:on");
            entrypoint.add("-Djava.awt.headless=true");
            entrypoint.add("-Djava.library.path=/function/runtime/lib");
            entrypoint.add("-cp");
            entrypoint.add("/function/app/classes:/function/app/libs/*:/function/app/resources:/function/runtime/*");
            entrypoint.add("com.fnproject.fn.runtime.EntryPoint");
        }
        return entrypoint;
    }

    public static String determineProjectFnVersion(String javaVersion) {
        int majorVersion = Integer.parseInt(javaVersion.split("\\.")[0]);
        if (majorVersion == 1) {
            majorVersion = Integer.parseInt(javaVersion.split("\\.")[1]);
        }
        if (majorVersion >= 17) {
            return "jre17-latest";
        }
        if (majorVersion >= 11) {
            return "jre11-latest";
        }
        return "latest";
    }

    private LayerObject remapLayer(LayerObject layerObject) {
        FileEntriesLayer originalLayer = (FileEntriesLayer)layerObject;
        FileEntriesLayer.Builder builder = FileEntriesLayer.builder().setName(originalLayer.getName());
        for (FileEntry originalEntry : originalLayer.getEntries()) {
            builder.addEntry(this.remapEntry(originalEntry, layerObject.getName()));
        }
        return builder.build();
    }

    private FileEntry remapEntry(FileEntry originalEntry, String layerName) {
        List pathComponents = UnixPathParser.parse((String)originalEntry.getExtractionPath().toString());
        AbsoluteUnixPath newPath = layerName.contains("dependencies") ? AbsoluteUnixPath.get((String)("/function/app/libs/" + (String)pathComponents.get(pathComponents.size() - 1))) : AbsoluteUnixPath.get((String)("/function" + originalEntry.getExtractionPath()));
        return new FileEntry(originalEntry.getSourceFile(), newPath, originalEntry.getPermissions(), originalEntry.getModificationTime(), originalEntry.getOwnership());
    }
}

