/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build;

import com.github.dockerjava.api.command.PushImageCmd;
import com.github.dockerjava.api.model.AuthConfig;
import com.google.cloud.tools.jib.api.Credential;
import io.micronaut.build.AbstractDockerMojo;
import io.micronaut.build.Packaging;
import io.micronaut.build.services.ApplicationConfigurationService;
import io.micronaut.build.services.DockerService;
import io.micronaut.build.services.JibConfigurationService;
import java.util.Set;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.RegistryAuthLocator;

@Mojo(name="docker-push")
public class DockerPushMojo
extends AbstractDockerMojo {
    @Inject
    public DockerPushMojo(MavenProject mavenProject, JibConfigurationService jibConfigurationService, ApplicationConfigurationService applicationConfigurationService, DockerService dockerService) {
        super(mavenProject, jibConfigurationService, applicationConfigurationService, dockerService);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        Packaging packaging = Packaging.of(this.mavenProject.getPackaging());
        if (packaging != Packaging.DOCKER && packaging != Packaging.DOCKER_NATIVE && packaging != Packaging.DOCKER_CRAC) throw new MojoFailureException("The <packaging> must be set to either [" + Packaging.DOCKER.id() + "] or [" + Packaging.DOCKER_NATIVE.id() + "]");
        Set<String> images = this.getTags();
        if (!this.jibConfigurationService.getToImage().isPresent()) throw new MojoFailureException("The plugin com.google.cloud.tools:jib-maven-plugin is misconfigured. Missing <to> tag");
        for (String taggedImage : images) {
            this.getLog().info((CharSequence)("Pushing image: " + taggedImage));
            try {
                PushImageCmd pushImageCmd = this.dockerService.pushImageCmd(taggedImage);
                Throwable throwable = null;
                try {
                    AuthConfig defaultAuthConfig = new AuthConfig();
                    if (this.jibConfigurationService.getCredentials().isPresent()) {
                        Credential credential = this.jibConfigurationService.getCredentials().get();
                        defaultAuthConfig.withUsername(credential.getUsername()).withPassword(credential.getPassword());
                    }
                    RegistryAuthLocator registryAuthLocator = RegistryAuthLocator.instance();
                    DockerImageName dockerImageName = DockerImageName.parse((String)taggedImage);
                    AuthConfig authConfig = registryAuthLocator.lookupAuthConfig(dockerImageName, defaultAuthConfig);
                    pushImageCmd.withAuthConfig(authConfig).start().awaitCompletion();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (pushImageCmd == null) continue;
                    if (throwable != null) {
                        try {
                            pushImageCmd.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    pushImageCmd.close();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
    }
}

