/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cache.ehcache;

import io.micronaut.cache.ehcache.EhcacheSyncCache;
import io.micronaut.cache.ehcache.configuration.EhcacheCacheManagerConfiguration;
import io.micronaut.cache.ehcache.configuration.EhcacheConfiguration;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.convert.ConversionService;
import java.util.concurrent.ExecutorService;
import javax.inject.Named;
import javax.inject.Singleton;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.core.spi.service.StatisticsService;
import org.ehcache.core.statistics.DefaultStatisticsService;
import org.ehcache.spi.service.Service;

@Factory
public class EhcacheCacheFactory {
    private EhcacheCacheManagerConfiguration configuration;

    public EhcacheCacheFactory(EhcacheCacheManagerConfiguration configuration) {
        this.configuration = configuration;
    }

    @Singleton
    @Bean(preDestroy="close")
    CacheManager cacheManager(StatisticsService statisticsService) {
        CacheManagerBuilder builder = this.configuration.getBuilder();
        return builder.using((Service)statisticsService).build(true);
    }

    @Singleton
    @Bean(preDestroy="stop")
    StatisticsService statisticsService() {
        return new DefaultStatisticsService();
    }

    @EachBean(value=EhcacheConfiguration.class)
    EhcacheSyncCache syncCache(@Parameter EhcacheConfiguration configuration, CacheManager cacheManager, ConversionService<?> conversionService, @Named(value="io") ExecutorService executorService, StatisticsService statisticsService) {
        Cache nativeCache = cacheManager.createCache(configuration.getName(), configuration.getBuilder());
        return new EhcacheSyncCache(conversionService, configuration, nativeCache, executorService, statisticsService);
    }
}

