/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cache.ehcache;

import io.micronaut.cache.CacheInfo;
import io.micronaut.cache.SyncCache;
import io.micronaut.cache.ehcache.configuration.EhcacheConfiguration;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import javax.inject.Named;
import org.ehcache.Cache;
import org.ehcache.core.spi.service.StatisticsService;
import org.ehcache.core.statistics.CacheStatistics;
import org.reactivestreams.Publisher;

public class EhcacheSyncCache
implements SyncCache<Cache> {
    private final ConversionService<?> conversionService;
    private final EhcacheConfiguration configuration;
    private final Cache nativeCache;
    private final ExecutorService executorService;
    private final StatisticsService statisticsService;

    public EhcacheSyncCache(ConversionService<?> conversionService, EhcacheConfiguration configuration, Cache nativeCache, @Named(value="io") ExecutorService executorService, StatisticsService statisticsService) {
        this.conversionService = conversionService;
        this.configuration = configuration;
        this.nativeCache = nativeCache;
        this.executorService = executorService;
        this.statisticsService = statisticsService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @NonNull
    public <T> Optional<T> get(@NonNull Object key, @NonNull Argument<T> requiredType) {
        ArgumentUtils.requireNonNull((String)"key", (Object)key);
        Object value = this.nativeCache.get(key);
        if (value != null) {
            return this.conversionService.convert(value, ConversionContext.of(requiredType));
        }
        return Optional.empty();
    }

    public <T> T get(@NonNull Object key, @NonNull Argument<T> requiredType, @NonNull Supplier<T> supplier) {
        ArgumentUtils.requireNonNull((String)"key", (Object)key);
        Optional<T> existingValue = this.get(key, requiredType);
        if (existingValue.isPresent()) {
            return existingValue.get();
        }
        T value = supplier.get();
        this.put(key, value);
        return value;
    }

    @NonNull
    public <T> Optional<T> putIfAbsent(@NonNull Object key, @NonNull T value) {
        ArgumentUtils.requireNonNull((String)"key", (Object)key);
        ArgumentUtils.requireNonNull((String)"value", value);
        Object v = this.nativeCache.putIfAbsent(key, value);
        Class<?> aClass = value.getClass();
        return this.conversionService.convert(v, aClass);
    }

    public void put(@NonNull Object key, @NonNull Object value) {
        ArgumentUtils.requireNonNull((String)"key", (Object)key);
        ArgumentUtils.requireNonNull((String)"value", (Object)value);
        this.nativeCache.put(key, value);
    }

    public void invalidate(@NonNull Object key) {
        ArgumentUtils.requireNonNull((String)"key", (Object)key);
        this.nativeCache.remove(key);
    }

    public void invalidateAll() {
        this.nativeCache.clear();
    }

    public String getName() {
        return this.configuration.getName();
    }

    public Cache getNativeCache() {
        return this.nativeCache;
    }

    public Publisher<CacheInfo> getCacheInfo() {
        CacheInfo cacheInfo = new CacheInfo(){

            @NonNull
            public Map<String, Object> get() {
                LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>(2);
                data.put("implementationClass", EhcacheSyncCache.this.getNativeCache().getClass().getName());
                data.put("ehcache", EhcacheSyncCache.this.getEhcacheInfo());
                return data;
            }

            @NonNull
            public String getName() {
                return EhcacheSyncCache.this.configuration.getName();
            }
        };
        return Publishers.just((Object)cacheInfo);
    }

    private Map<String, Object> getEhcacheInfo() {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>(8);
        CacheStatistics statistics = this.statisticsService.getCacheStatistics(this.configuration.getName());
        values.put("cacheEvictions", statistics.getCacheEvictions());
        values.put("cacheExpirations", statistics.getCacheExpirations());
        values.put("cacheGets", statistics.getCacheGets());
        values.put("cacheHitPercentage", Float.valueOf(statistics.getCacheHitPercentage()));
        values.put("cacheHits", statistics.getCacheHits());
        values.put("cacheMisses", statistics.getCacheMisses());
        values.put("cacheMissPercentage", Float.valueOf(statistics.getCacheMissPercentage()));
        values.put("cachePuts", statistics.getCachePuts());
        values.put("cacheRemovals", statistics.getCacheRemovals());
        return values;
    }
}

