/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cache.ehcache.configuration;

import io.micronaut.cache.ehcache.configuration.AbstractResourcePoolConfiguration;
import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.convert.format.ReadableBytes;
import io.micronaut.core.naming.Named;
import java.io.Serializable;
import org.ehcache.clustered.client.config.builders.ClusteredResourcePoolBuilder;
import org.ehcache.config.Builder;
import org.ehcache.config.ResourcePool;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.EntryUnit;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.impl.config.store.disk.OffHeapDiskStoreConfiguration;
import org.ehcache.spi.service.ServiceConfiguration;

@EachProperty(value="ehcache.caches")
public class EhcacheConfiguration
implements Named {
    public static final String PREFIX = "ehcache.caches";
    public static final Class<?> DEFAULT_KEY_TYPE = Serializable.class;
    public static final Class<?> DEFAULT_VALUE_TYPE = Serializable.class;
    public static final Long DEFAULT_MAX_ENTRIES = 100L;
    @ConfigurationBuilder(prefixes={"with"})
    CacheConfigurationBuilder<?, ?> builder;
    private final String name;
    private Class<?> keyType = DEFAULT_KEY_TYPE;
    private Class<?> valueType = DEFAULT_VALUE_TYPE;
    private HeapTieredCacheConfiguration heap;
    private OffheapTieredCacheConfiguration offheap;
    private DiskTieredCacheConfiguration disk;
    private ClusteredDedicatedResourcePoolConfiguration clusteredDedicated;
    private ClusteredSharedResourcePoolConfiguration clusteredShared;

    public EhcacheConfiguration(@Parameter String name) {
        this.name = name;
    }

    public CacheConfigurationBuilder<?, ?> getBuilder() {
        ResourcePoolsBuilder resourcePoolsBuilder = ResourcePoolsBuilder.newResourcePoolsBuilder();
        boolean resourcePoolAdded = false;
        if (this.heap != null) {
            if (this.heap.getMaxSize() != null) {
                resourcePoolsBuilder = resourcePoolsBuilder.heap(this.heap.getMaxSize().longValue(), (ResourceUnit)MemoryUnit.B);
                resourcePoolAdded = true;
            } else if (this.heap.getMaxEntries() != null) {
                resourcePoolsBuilder = resourcePoolsBuilder.heap(this.heap.getMaxEntries().longValue(), (ResourceUnit)EntryUnit.ENTRIES);
                resourcePoolAdded = true;
            }
        }
        if (this.offheap != null && this.offheap.getMaxSize() != null) {
            resourcePoolsBuilder = resourcePoolsBuilder.offheap(this.offheap.getMaxSize().longValue(), MemoryUnit.B);
            resourcePoolAdded = true;
        }
        if (this.disk != null && this.disk.getMaxSize() != null) {
            resourcePoolsBuilder = resourcePoolsBuilder.disk(this.disk.getMaxSize().longValue(), MemoryUnit.B);
            resourcePoolAdded = true;
        }
        if (this.clusteredDedicated != null && this.clusteredDedicated.getMaxSize() != null) {
            if (this.clusteredDedicated.getServerResource() != null) {
                resourcePoolsBuilder = resourcePoolsBuilder.with((ResourcePool)ClusteredResourcePoolBuilder.clusteredDedicated((String)this.clusteredDedicated.getServerResource(), (long)this.clusteredDedicated.getMaxSize(), (MemoryUnit)MemoryUnit.B));
                resourcePoolAdded = true;
            } else {
                resourcePoolsBuilder = resourcePoolsBuilder.with((ResourcePool)ClusteredResourcePoolBuilder.clusteredDedicated((long)this.clusteredDedicated.getMaxSize(), (MemoryUnit)MemoryUnit.B));
                resourcePoolAdded = true;
            }
        }
        if (this.clusteredShared != null && this.clusteredShared.getServerResource() != null) {
            resourcePoolsBuilder = resourcePoolsBuilder.with((ResourcePool)ClusteredResourcePoolBuilder.clusteredShared((String)this.clusteredShared.getServerResource()));
            resourcePoolAdded = true;
        }
        if (!resourcePoolAdded) {
            resourcePoolsBuilder = ResourcePoolsBuilder.heap((long)DEFAULT_MAX_ENTRIES);
        }
        this.builder = CacheConfigurationBuilder.newCacheConfigurationBuilder(this.keyType, this.valueType, (Builder)resourcePoolsBuilder);
        if (this.heap != null && this.heap.getSizeOfMaxObjectSize() != null) {
            this.builder = this.builder.withSizeOfMaxObjectGraph(this.heap.getSizeOfMaxObjectSize().longValue());
        }
        if (this.disk != null && this.disk.getSegments() != null) {
            this.builder = this.builder.withService((ServiceConfiguration)new OffHeapDiskStoreConfiguration(this.disk.getSegments().intValue()));
        }
        return this.builder;
    }

    public void setBuilder(CacheConfigurationBuilder builder) {
        this.builder = builder;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public Class<?> getKeyType() {
        return this.keyType;
    }

    public void setKeyType(Class<?> keyType) {
        this.keyType = keyType;
    }

    public Class<?> getValueType() {
        return this.valueType;
    }

    public void setValueType(Class<?> valueType) {
        this.valueType = valueType;
    }

    public HeapTieredCacheConfiguration getHeap() {
        return this.heap;
    }

    public void setHeap(HeapTieredCacheConfiguration heap) {
        this.heap = heap;
    }

    public OffheapTieredCacheConfiguration getOffheap() {
        return this.offheap;
    }

    public void setOffheap(OffheapTieredCacheConfiguration offheap) {
        this.offheap = offheap;
    }

    public DiskTieredCacheConfiguration getDisk() {
        return this.disk;
    }

    public void setDisk(DiskTieredCacheConfiguration disk) {
        this.disk = disk;
    }

    public ClusteredDedicatedResourcePoolConfiguration getClusteredDedicated() {
        return this.clusteredDedicated;
    }

    public void setClusteredDedicated(ClusteredDedicatedResourcePoolConfiguration clusteredDedicated) {
        this.clusteredDedicated = clusteredDedicated;
    }

    public ClusteredSharedResourcePoolConfiguration getClusteredShared() {
        return this.clusteredShared;
    }

    public void setClusteredShared(ClusteredSharedResourcePoolConfiguration clusteredShared) {
        this.clusteredShared = clusteredShared;
    }

    @ConfigurationProperties(value="clustered-shared")
    public static class ClusteredSharedResourcePoolConfiguration {
        public static final String PREFIX = "clustered-shared";
        private String serverResource;

        public String getServerResource() {
            return this.serverResource;
        }

        public void setServerResource(String serverResource) {
            this.serverResource = serverResource;
        }
    }

    @ConfigurationProperties(value="clustered-dedicated")
    public static class ClusteredDedicatedResourcePoolConfiguration
    extends AbstractResourcePoolConfiguration {
        public static final String PREFIX = "clustered-dedicated";
        private String serverResource;

        public String getServerResource() {
            return this.serverResource;
        }

        public void setServerResource(String serverResource) {
            this.serverResource = serverResource;
        }
    }

    @ConfigurationProperties(value="disk")
    public static class DiskTieredCacheConfiguration
    extends AbstractResourcePoolConfiguration {
        public static final String PREFIX = "disk";
        private Integer segments;

        public Integer getSegments() {
            return this.segments;
        }

        public void setSegments(Integer segments) {
            this.segments = segments;
        }
    }

    @ConfigurationProperties(value="offheap")
    public static class OffheapTieredCacheConfiguration
    extends AbstractResourcePoolConfiguration {
        public static final String PREFIX = "offheap";
    }

    @ConfigurationProperties(value="heap")
    public static class HeapTieredCacheConfiguration
    extends AbstractResourcePoolConfiguration {
        public static final String PREFIX = "heap";
        private Long maxEntries = DEFAULT_MAX_ENTRIES;
        private Long sizeOfMaxObjectSize;

        public Long getMaxEntries() {
            return this.maxEntries;
        }

        public void setMaxEntries(Long maxEntries) {
            this.maxEntries = maxEntries;
        }

        public Long getSizeOfMaxObjectSize() {
            return this.sizeOfMaxObjectSize;
        }

        public void setSizeOfMaxObjectSize(@ReadableBytes Long sizeOfMaxObjectSize) {
            this.sizeOfMaxObjectSize = sizeOfMaxObjectSize;
        }
    }
}

