/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cache.ehcache.configuration;

import io.micronaut.cache.ehcache.configuration.EhcacheClusterResourcePoolConfiguration;
import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.core.convert.format.ReadableBytes;
import java.io.File;
import java.net.URI;
import java.util.List;
import org.ehcache.clustered.client.config.builders.ClusteringServiceConfigurationBuilder;
import org.ehcache.clustered.client.config.builders.ServerSideConfigurationBuilder;
import org.ehcache.config.Builder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.units.MemoryUnit;

@ConfigurationProperties(value="ehcache")
public class EhcacheCacheManagerConfiguration {
    public static final String PREFIX = "ehcache";
    @ConfigurationBuilder(prefixes={"with"}, excludes={""})
    private CacheManagerBuilder builder;
    private EhcacheClusterConfiguration cluster;
    private Long defaultSizeOfMaxObjectSize;
    private String storagePath;
    private List<EhcacheClusterResourcePoolConfiguration> resourcePoolConfigurations;

    public EhcacheCacheManagerConfiguration(List<EhcacheClusterResourcePoolConfiguration> resourcePoolConfigurations) {
        this.resourcePoolConfigurations = resourcePoolConfigurations;
    }

    public CacheManagerBuilder getBuilder() {
        if (this.builder == null) {
            this.builder = CacheManagerBuilder.newCacheManagerBuilder();
        }
        if (this.defaultSizeOfMaxObjectSize != null) {
            this.builder = this.builder.withDefaultSizeOfMaxObjectSize(this.defaultSizeOfMaxObjectSize.longValue(), MemoryUnit.B);
        }
        if (this.getStoragePath() != null) {
            File storagePath = new File(this.getStoragePath());
            this.builder = this.builder.with(CacheManagerBuilder.persistence((File)storagePath));
        }
        if (this.cluster != null && this.cluster.getUri() != null) {
            URI clusterUri = URI.create(this.cluster.getUri());
            this.builder = this.builder.with((Builder)ClusteringServiceConfigurationBuilder.cluster((URI)clusterUri).autoCreate(this::configureServer));
        }
        return this.builder;
    }

    public void setBuilder(CacheManagerBuilder builder) {
        this.builder = builder;
    }

    public Long getDefaultSizeOfMaxObjectSize() {
        return this.defaultSizeOfMaxObjectSize;
    }

    public void setDefaultSizeOfMaxObjectSize(@ReadableBytes Long defaultSizeOfMaxObjectSize) {
        this.defaultSizeOfMaxObjectSize = defaultSizeOfMaxObjectSize;
    }

    public String getStoragePath() {
        return this.storagePath;
    }

    public void setStoragePath(String storagePath) {
        this.storagePath = storagePath;
    }

    public EhcacheClusterConfiguration getCluster() {
        return this.cluster;
    }

    public void setCluster(EhcacheClusterConfiguration cluster) {
        this.cluster = cluster;
    }

    private ServerSideConfigurationBuilder configureServer(ServerSideConfigurationBuilder server) {
        if (this.cluster.getDefaultServerResource() != null) {
            server = server.defaultServerResource(this.cluster.defaultServerResource);
        }
        if (this.resourcePoolConfigurations != null) {
            for (EhcacheClusterResourcePoolConfiguration resourcePoolConfiguration : this.resourcePoolConfigurations) {
                if (resourcePoolConfiguration.getServerResource() != null) {
                    server = server.resourcePool(resourcePoolConfiguration.getName(), resourcePoolConfiguration.getMaxSize().longValue(), MemoryUnit.B, resourcePoolConfiguration.getServerResource());
                    continue;
                }
                server = server.resourcePool(resourcePoolConfiguration.getName(), resourcePoolConfiguration.getMaxSize().longValue(), MemoryUnit.B);
            }
        }
        return server;
    }

    @ConfigurationProperties(value="cluster")
    public static class EhcacheClusterConfiguration {
        public static final String PREFIX = "cluster";
        private String uri;
        private String defaultServerResource;

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public String getDefaultServerResource() {
            return this.defaultServerResource;
        }

        public void setDefaultServerResource(String defaultServerResource) {
            this.defaultServerResource = defaultServerResource;
        }
    }
}

