/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cache.hazelcast;

import com.hazelcast.map.IMap;
import io.micronaut.cache.AsyncCache;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;

public class HazelcastAsyncCache
implements AsyncCache<IMap<Object, Object>> {
    private final ConversionService<?> conversionService;
    private final IMap<Object, Object> nativeCache;
    private final ExecutorService executorService;

    public HazelcastAsyncCache(ConversionService<?> conversionService, IMap<Object, Object> nativeCache, ExecutorService executorService) {
        this.conversionService = conversionService;
        this.nativeCache = nativeCache;
        this.executorService = executorService;
    }

    @NonNull
    public <T> CompletableFuture<Optional<T>> get(@NonNull Object key, @NonNull Argument<T> requiredType) {
        ArgumentUtils.requireNonNull((String)"key", (Object)key);
        CompletableFuture future = new CompletableFuture();
        this.nativeCache.getAsync(key).whenCompleteAsync((response, throwable) -> {
            if (throwable == null) {
                if (response != null) {
                    future.complete(this.conversionService.convert(response, ConversionContext.of((Argument)requiredType)));
                } else {
                    future.complete(Optional.empty());
                }
            } else {
                future.completeExceptionally((Throwable)throwable);
            }
        }, this.executorService);
        return future;
    }

    public <T> CompletableFuture<T> get(@NonNull Object key, @NonNull Argument<T> requiredType, @NonNull Supplier<T> supplier) {
        ArgumentUtils.requireNonNull((String)"key", (Object)key);
        CompletableFuture<Optional<T>> optionalCompletableFuture = this.get(key, requiredType);
        return optionalCompletableFuture.thenApply(existingValue -> {
            if (existingValue.isPresent()) {
                return existingValue.get();
            }
            Object value = supplier.get();
            this.put(key, value);
            return value;
        });
    }

    @NonNull
    public <T> CompletableFuture<Optional<T>> putIfAbsent(@NonNull Object key, @NonNull T value) {
        ArgumentUtils.requireNonNull((String)"key", (Object)key);
        ArgumentUtils.requireNonNull((String)"value", value);
        return CompletableFuture.supplyAsync(() -> {
            Object remoteValue = this.nativeCache.putIfAbsent(key, value);
            if (remoteValue == null) {
                return Optional.empty();
            }
            Class<?> aClass = value.getClass();
            return this.conversionService.convert(remoteValue, aClass);
        }, this.executorService);
    }

    public CompletableFuture<Boolean> put(@NonNull Object key, @NonNull Object value) {
        ArgumentUtils.requireNonNull((String)"key", (Object)key);
        ArgumentUtils.requireNonNull((String)"value", (Object)value);
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.nativeCache.setAsync(key, value).whenCompleteAsync((response, throwable) -> {
            if (throwable == null) {
                future.complete(true);
            } else {
                future.completeExceptionally((Throwable)throwable);
            }
        }, this.executorService);
        return future;
    }

    public CompletableFuture<Boolean> invalidate(@NonNull Object key) {
        ArgumentUtils.requireNonNull((String)"key", (Object)key);
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.nativeCache.removeAsync(key).whenCompleteAsync((response, throwable) -> {
            if (throwable == null) {
                future.complete(true);
            } else {
                future.completeExceptionally((Throwable)throwable);
            }
        }, this.executorService);
        return future;
    }

    public CompletableFuture<Boolean> invalidateAll() {
        return CompletableFuture.supplyAsync(() -> {
            this.nativeCache.clear();
            return true;
        }, this.executorService);
    }

    public String getName() {
        return this.nativeCache.getName();
    }

    public IMap getNativeCache() {
        return this.nativeCache;
    }
}

