/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cache.hazelcast.condition;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.context.env.Environment;
import io.micronaut.core.io.ResourceLoader;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.core.io.file.FileSystemResourceLoader;
import io.micronaut.core.io.scan.ClassPathResourceLoader;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

public class HazelcastConfigResourceCondition
implements Condition {
    public static final String[] CLIENT_CONFIG_FILES = new String[]{"hazelcast-client.xml", "hazelcast-client.yml", "classpath:hazelcast-client.xml", "classpath:hazelcast-client.yml"};
    public static final String[] INSTANCE_CONFIG_FILES = new String[]{"hazelcast.xml", "hazelcast.yml", "classpath:hazelcast.xml", "classpath:hazelcast.yml"};

    public boolean matches(ConditionContext context) {
        String[] allConfigFiles = (String[])Stream.concat(Arrays.stream(CLIENT_CONFIG_FILES), Arrays.stream(INSTANCE_CONFIG_FILES)).toArray(String[]::new);
        return !this.resourceExists(context, allConfigFiles);
    }

    protected boolean resourceExists(ConditionContext<?> context, String[] paths) {
        List<ResourceLoader> resourceLoaders;
        BeanContext beanContext = context.getBeanContext();
        if (beanContext instanceof ApplicationContext) {
            Environment resourceLoader = ((ApplicationContext)beanContext).getEnvironment();
            resourceLoaders = Arrays.asList(resourceLoader, FileSystemResourceLoader.defaultLoader());
        } else {
            resourceLoaders = Arrays.asList(ClassPathResourceLoader.defaultLoader((ClassLoader)beanContext.getClassLoader()), FileSystemResourceLoader.defaultLoader());
        }
        ResourceResolver resolver = new ResourceResolver(resourceLoaders);
        for (String resourcePath : paths) {
            if (!resolver.getResource(resourcePath).isPresent()) continue;
            return true;
        }
        return false;
    }

    public static class HazelcastInstanceConfigCondition
    extends HazelcastConfigResourceCondition {
        @Override
        public boolean matches(ConditionContext context) {
            return this.resourceExists(context, INSTANCE_CONFIG_FILES);
        }
    }

    public static class HazelcastClientConfigCondition
    extends HazelcastConfigResourceCondition {
        @Override
        public boolean matches(ConditionContext context) {
            return this.resourceExists(context, CLIENT_CONFIG_FILES);
        }
    }
}

