/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cache.hazelcast;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import io.micronaut.cache.DynamicCacheManager;
import io.micronaut.cache.SyncCache;
import io.micronaut.cache.hazelcast.HazelcastSyncCache;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.convert.ConversionService;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.concurrent.ExecutorService;

@Singleton
public class HazelcastCacheManager
implements DynamicCacheManager<IMap<Object, Object>> {
    private final ConversionService conversionService;
    private final ExecutorService executorService;
    private final HazelcastInstance hazelcastInstance;

    public HazelcastCacheManager(ConversionService conversionService, HazelcastInstance hazelcastInstance, @Named(value="io") ExecutorService executorService) {
        this.conversionService = conversionService;
        this.executorService = executorService;
        this.hazelcastInstance = hazelcastInstance;
    }

    @NonNull
    public SyncCache<IMap<Object, Object>> getCache(String name) {
        IMap nativeCache = this.hazelcastInstance.getMap(name);
        return new HazelcastSyncCache(this.conversionService, (IMap<Object, Object>)nativeCache, this.executorService);
    }
}

