/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cache.hazelcast;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import io.micronaut.cache.hazelcast.HazelcastClientConfiguration;
import io.micronaut.cache.hazelcast.HazelcastMemberConfiguration;
import io.micronaut.cache.hazelcast.condition.HazelcastConfigResourceCondition;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import jakarta.inject.Named;
import jakarta.inject.Singleton;

@Factory
public class HazelcastFactory {
    @Requires(beans={ClientConfig.class})
    @Singleton
    @Bean(preDestroy="shutdown")
    public HazelcastInstance hazelcastInstance(ClientConfig clientConfig) {
        HazelcastClientConfiguration client;
        if (clientConfig instanceof HazelcastClientConfiguration && (client = (HazelcastClientConfiguration)clientConfig).getConfig() != null) {
            System.setProperty("hazelcast.client.config", client.getConfig());
            return HazelcastClient.newHazelcastClient();
        }
        return HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
    }

    @Requires(beans={Config.class})
    @Singleton
    @Bean(preDestroy="shutdown")
    public HazelcastInstance hazelcastInstance(Config config) {
        HazelcastMemberConfiguration member;
        if (config instanceof HazelcastMemberConfiguration && (member = (HazelcastMemberConfiguration)config).getConfig() != null) {
            System.setProperty("hazelcast.config", member.getConfig());
            return Hazelcast.newHazelcastInstance();
        }
        return Hazelcast.newHazelcastInstance((Config)config);
    }

    @Requirements(value={@Requires(missingBeans={Config.class, ClientConfig.class}), @Requires(condition=HazelcastConfigResourceCondition.HazelcastClientConfigCondition.class)})
    @Singleton
    @Named(value="hazelcastInstance")
    @Bean(preDestroy="shutdown")
    public HazelcastInstance hazelcastClient() {
        return HazelcastClient.newHazelcastClient();
    }

    @Requirements(value={@Requires(missingBeans={Config.class, ClientConfig.class}), @Requires(condition=HazelcastConfigResourceCondition.HazelcastInstanceConfigCondition.class)})
    @Singleton
    @Bean(preDestroy="shutdown")
    public HazelcastInstance hazelcastInstance() {
        return Hazelcast.newHazelcastInstance();
    }
}

