/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cache.hazelcast;

import com.hazelcast.map.IMap;
import io.micronaut.cache.AbstractMapBasedSyncCache;
import io.micronaut.cache.AsyncCache;
import io.micronaut.cache.hazelcast.HazelcastAsyncCache;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.util.ArgumentUtils;
import java.util.concurrent.ExecutorService;

public class HazelcastSyncCache
extends AbstractMapBasedSyncCache<IMap<Object, Object>> {
    private final ExecutorService executorService;

    public HazelcastSyncCache(ConversionService conversionService, IMap<Object, Object> nativeCache, ExecutorService executorService) {
        super(conversionService, nativeCache);
        this.executorService = executorService;
    }

    public void put(@NonNull Object key, @NonNull Object value) {
        ArgumentUtils.requireNonNull((String)"key", (Object)key);
        ArgumentUtils.requireNonNull((String)"value", (Object)value);
        ((IMap)this.getNativeCache()).set(key, value);
    }

    public String getName() {
        return ((IMap)this.getNativeCache()).getName();
    }

    public AsyncCache<IMap<Object, Object>> async() {
        return new HazelcastAsyncCache(this.getConversionService(), (IMap<Object, Object>)((IMap)this.getNativeCache()), this.executorService);
    }
}

