/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cache.management;

import io.micronaut.cache.AsyncCache;
import io.micronaut.cache.Cache;
import io.micronaut.cache.CacheInfo;
import io.micronaut.cache.CacheManager;
import io.micronaut.cache.SyncCache;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.management.endpoint.annotation.Delete;
import io.micronaut.management.endpoint.annotation.Endpoint;
import io.micronaut.management.endpoint.annotation.Read;
import io.micronaut.management.endpoint.annotation.Selector;
import jakarta.validation.constraints.NotBlank;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Endpoint(id="caches", defaultEnabled=false)
public class CachesEndpoint {
    public static final String NAME = "caches";
    private final CacheManager<Object> cacheManager;

    public CachesEndpoint(CacheManager<Object> cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Read
    public Mono<Map<String, Object>> getCaches() {
        return Flux.fromIterable((Iterable)this.cacheManager.getCacheNames()).map(arg_0 -> this.cacheManager.getCache(arg_0)).map(Cache::getCacheInfo).map(Flux::from).flatMap(cacheInfoFlux -> cacheInfoFlux.take(1L)).reduce(new HashMap(), (seed, info) -> {
            seed.put(info.getName(), info.get());
            return seed;
        }).map(objectObjectHashMap -> Collections.singletonMap(NAME, objectObjectHashMap));
    }

    @Read
    public Mono<Map<String, Object>> getCache(@NotBlank @Selector String name) {
        return Mono.just((Object)name).map(arg_0 -> this.cacheManager.getCache(arg_0)).flux().flatMap(Cache::getCacheInfo).map(CacheInfo::get).elementAt(0).onErrorResume(e -> Mono.empty());
    }

    @Read
    public Mono<Map<String, Object>> getCacheEntry(@NotBlank @Selector String name, @NotBlank @Selector String key) {
        return Mono.just((Object)name).map(arg_0 -> this.cacheManager.getCache(arg_0)).map(SyncCache::async).map(asyncCache -> asyncCache.get((Object)key, Object.class)).flatMap(Mono::fromFuture).flatMap(optional -> optional.map(Mono::just).orElseGet(Mono::empty)).map(value -> Map.of("key", key, "value", value)).onErrorResume(e -> Mono.empty());
    }

    @Delete
    public Mono<Boolean> invalidateCaches() {
        return Flux.fromIterable((Iterable)this.cacheManager.getCacheNames()).map(arg_0 -> this.cacheManager.getCache(arg_0)).map(SyncCache::async).map(AsyncCache::invalidateAll).flatMap(Publishers::fromCompletableFuture).reduce((aBoolean, aBoolean2) -> aBoolean != false && aBoolean2 != false).onErrorReturn((Object)false);
    }

    @Delete
    public Mono<Boolean> invalidateCache(@NotBlank @Selector String name) {
        return Mono.just((Object)name).map(arg_0 -> this.cacheManager.getCache(arg_0)).map(SyncCache::async).map(AsyncCache::invalidateAll).flatMap(Mono::fromFuture).onErrorReturn((Object)false);
    }

    @Delete
    public Mono<Boolean> invalidateCacheKey(@NotBlank @Selector String name, @NotBlank @Selector String key) {
        return Mono.just((Object)name).map(arg_0 -> this.cacheManager.getCache(arg_0)).map(SyncCache::async).map(asyncCache -> asyncCache.invalidate((Object)key)).flatMap(Mono::fromFuture).onErrorReturn((Object)false);
    }
}

