/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cache.noop;

import io.micronaut.cache.CacheManager;
import io.micronaut.cache.DefaultCacheManager;
import io.micronaut.cache.SyncCache;
import io.micronaut.cache.noop.NoOpSyncCache;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@Replaces(value=DefaultCacheManager.class)
@Requires(property="noop-cache.enabled", value="true")
@Primary
public class NoOpCacheManager
implements CacheManager<Object> {
    private Map<String, NoOpSyncCache> cacheMap = new ConcurrentHashMap<String, NoOpSyncCache>();

    @NonNull
    public Set<String> getCacheNames() {
        return this.cacheMap.keySet();
    }

    @NonNull
    public SyncCache<Object> getCache(String name) {
        NoOpSyncCache syncCache = this.cacheMap.get(name);
        if (syncCache == null) {
            syncCache = new NoOpSyncCache(name);
            this.cacheMap.put(name, syncCache);
        }
        return syncCache;
    }
}

