/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.internal.core.config.typesafe.DefaultDriverConfigLoader;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import io.micronaut.cassandra.CassandraConfiguration;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.core.value.PropertyResolver;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Factory
public class CassandraSessionFactory
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(CassandraSessionFactory.class);
    private final List<CqlSession> sessions = new ArrayList<CqlSession>(2);
    private final PropertyResolver resolver;

    public CassandraSessionFactory(PropertyResolver propertyResolver) {
        this.resolver = propertyResolver;
    }

    @EachBean(value=CassandraConfiguration.class)
    public CqlSessionBuilder session(CassandraConfiguration configuration) {
        try {
            return (CqlSessionBuilder)CqlSession.builder().withConfigLoader((DriverConfigLoader)new DefaultDriverConfigLoader(() -> {
                ConfigFactory.invalidateCaches();
                String prefix = configuration.getName();
                Map<String, Object> properties = this.resolver.getProperties("cassandra." + prefix);
                properties = properties.entrySet().stream().filter(e -> !(e.getValue() instanceof Collection)).collect(Collectors.toMap(e -> ((String)e.getKey()).replaceAll("\\[(\\d+)]", ".$1"), Map.Entry::getValue));
                return ConfigFactory.parseMap(properties).withFallback((ConfigMergeable)ConfigFactory.load().getConfig("datastax-java-driver"));
            }));
        }
        catch (Exception e) {
            LOG.error(String.format("Failed to instantiate CQL session: %s", e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    @EachBean(value=CqlSessionBuilder.class)
    public CqlSession cassandraCluster(CqlSessionBuilder builder) {
        CqlSession session = (CqlSession)builder.build();
        this.sessions.add(session);
        return session;
    }

    @Override
    @PreDestroy
    public void close() {
        for (CqlSession session : this.sessions) {
            try {
                session.close();
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn(String.format("Error closing data source [%s]: %s", session, e.getMessage()), (Throwable)e);
            }
        }
    }
}

