/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cassandra.metrics;

import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import io.micrometer.core.instrument.MeterRegistry;
import io.micronaut.configuration.metrics.annotation.RequiresMetrics;
import io.micronaut.context.BeanProvider;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.core.annotation.NonNull;
import jakarta.inject.Singleton;

@RequiresMetrics
@Requires(beans={CqlSessionBuilder.class})
@Singleton
public class CassandraMetricsBinder
implements BeanCreatedEventListener<CqlSessionBuilder> {
    private final BeanProvider<MeterRegistry> meterRegistryProvider;

    protected CassandraMetricsBinder(BeanProvider<MeterRegistry> meterRegistryProvider) {
        this.meterRegistryProvider = meterRegistryProvider;
    }

    public CqlSessionBuilder onCreated(@NonNull BeanCreatedEvent<CqlSessionBuilder> event) {
        MeterRegistry meterRegistry = (MeterRegistry)this.meterRegistryProvider.get();
        CqlSessionBuilder cqlSessionBuilder = (CqlSessionBuilder)event.getBean();
        return (CqlSessionBuilder)cqlSessionBuilder.withMetricRegistry((Object)meterRegistry);
    }
}

