/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cassandra.health;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.NodeState;
import com.datastax.oss.driver.api.core.session.Session;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.health.HealthStatus;
import io.micronaut.management.endpoint.health.HealthEndpoint;
import io.micronaut.management.health.indicator.AbstractHealthIndicator;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;

@Requirements(value={@Requires(property="endpoints.health.cassandra.enabled", notEquals="false"), @Requires(beans={HealthEndpoint.class, CqlSession.class})})
@Introspected
@Singleton
public class CassandraHealthIndicator
extends AbstractHealthIndicator<Map<String, Object>> {
    private final List<CqlSession> cqlSessions;

    @Deprecated(since="6.1.0", forRemoval=true)
    public CassandraHealthIndicator(CqlSession cqlSession) {
        this.cqlSessions = Collections.singletonList(cqlSession);
    }

    @Inject
    public CassandraHealthIndicator(List<CqlSession> cqlSessions) {
        this.cqlSessions = cqlSessions;
    }

    protected Map<String, Object> getHealthInformation() {
        return this.cqlSessions.stream().collect(Collectors.toMap(Session::getName, this::getHealthInformation, (a, b) -> b, LinkedHashMap::new));
    }

    private Map<String, Object> getHealthInformation(CqlSession cqlSession) {
        LinkedHashMap<String, Object> detail = new LinkedHashMap<String, Object>();
        Map nodes = cqlSession.getMetadata().getNodes();
        detail.put("session", cqlSession.isClosed() ? "CLOSED" : "OPEN");
        Optional opClusterName = cqlSession.getMetadata().getClusterName();
        opClusterName.ifPresent(s -> detail.put("cluster_name", s));
        Optional opKeyspace = cqlSession.getKeyspace();
        opKeyspace.ifPresent(cqlIdentifier -> detail.put("keyspace", cqlIdentifier.asInternal()));
        detail.put("nodes_count", nodes.keySet().size());
        HashMap nodesMap = new HashMap();
        EnumMap<NodeState, Integer> nodeStateMap = new EnumMap<NodeState, Integer>(NodeState.class);
        boolean up = false;
        int i = 0;
        for (Map.Entry entry : nodes.entrySet()) {
            UUID uuid = (UUID)entry.getKey();
            Node node = (Node)entry.getValue();
            nodeStateMap.merge(node.getState(), 1, Integer::sum);
            if (!cqlSession.isClosed() && node.getState() == NodeState.UP) {
                up = true;
            }
            if (i++ >= 10) continue;
            HashMap<String, Object> nodeMap = new HashMap<String, Object>();
            Optional opBroadcastAddress = node.getBroadcastAddress();
            opBroadcastAddress.ifPresent(inetSocketAddress -> nodeMap.put("broadcast_address", inetSocketAddress.getAddress()));
            nodeMap.put("endpoint", node.getEndPoint());
            nodeMap.put("state", node.getState());
            nodeMap.put("distance", node.getDistance());
            nodeMap.put("open_connections", node.getOpenConnections());
            nodeMap.put("cassandra_version", node.getCassandraVersion());
            nodeMap.put("datacenter", node.getDatacenter());
            nodeMap.put("rack", node.getRack());
            nodeMap.put("uptime_ms", node.getUpSinceMillis());
            nodeMap.put("is_reconnecting", node.isReconnecting());
            nodesMap.put(uuid, nodeMap);
        }
        detail.put("nodes_state", nodeStateMap);
        if (!nodesMap.isEmpty()) {
            detail.put("nodes (10 max.)", nodesMap);
        }
        this.healthStatus = up ? HealthStatus.UP : HealthStatus.DOWN;
        return detail;
    }

    protected String getName() {
        return "cassandra";
    }
}

