/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.chatbots.basecamp.lambda;

import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyResponseEvent;
import io.micronaut.chatbots.basecamp.api.Query;
import io.micronaut.chatbots.basecamp.core.BasecampBotConfiguration;
import io.micronaut.chatbots.basecamp.core.BasecampUserAgentValidator;
import io.micronaut.chatbots.core.Dispatcher;
import io.micronaut.chatbots.lambda.AbstractHandler;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.serde.ObjectMapper;
import jakarta.inject.Inject;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Handler
extends AbstractHandler<BasecampBotConfiguration, Query, String> {
    private static final Logger LOG = LoggerFactory.getLogger(Handler.class);
    @Inject
    ObjectMapper objectMapper;
    @Inject
    Dispatcher<BasecampBotConfiguration, Query, String> dispatcher;

    public Handler() {
    }

    public Handler(ApplicationContext applicationContext) {
        super(applicationContext);
    }

    public Handler(ApplicationContextBuilder applicationContextBuilder) {
        super(applicationContextBuilder);
    }

    @NonNull
    protected boolean validate(@NonNull APIGatewayProxyRequestEvent request) {
        return this.parseHeader(request, "User-Agent").map(BasecampUserAgentValidator::validateUserAgent).orElseGet(() -> {
            LOG.warn("Rejecting request because HTTP Header {} not present", (Object)"User-Agent");
            return false;
        });
    }

    @NonNull
    protected Optional<BasecampBotConfiguration> parseBot(@NonNull APIGatewayProxyRequestEvent request) {
        return Optional.empty();
    }

    @NonNull
    protected APIGatewayProxyResponseEvent okSerializer(@NonNull Object body) {
        return this.okHtml(body);
    }

    @NonNull
    protected ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @NonNull
    protected Dispatcher<BasecampBotConfiguration, Query, String> getDispatcher() {
        return this.dispatcher;
    }
}

