/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.chatbots.google.api;

import io.micronaut.http.HttpStatus;

public enum Code {
    OK,
    CANCELLED,
    UNKNOWN,
    INVALID_ARGUMENT,
    DEADLINE_EXCEEDED,
    NOT_FOUND,
    ALREADY_EXISTS,
    PERMISSION_DENIED,
    UNAUTHENTICATED,
    RESOURCE_EXHAUSTED,
    FAILED_PRECONDITION,
    ABORTED,
    OUT_OF_RANGE,
    UNIMPLEMENTED,
    INTERNAL,
    UNAVAILABLE,
    DATA_LOSS;


    public int toHttpStatusCode() {
        switch (this) {
            case OK: {
                return HttpStatus.OK.getCode();
            }
            case CANCELLED: {
                return 499;
            }
            case OUT_OF_RANGE: 
            case FAILED_PRECONDITION: 
            case INVALID_ARGUMENT: {
                return HttpStatus.BAD_REQUEST.getCode();
            }
            case DEADLINE_EXCEEDED: {
                return HttpStatus.GATEWAY_TIMEOUT.getCode();
            }
            case NOT_FOUND: {
                return HttpStatus.NOT_FOUND.getCode();
            }
            case ABORTED: 
            case ALREADY_EXISTS: {
                return HttpStatus.CONFLICT.getCode();
            }
            case PERMISSION_DENIED: {
                return HttpStatus.FORBIDDEN.getCode();
            }
            case UNAUTHENTICATED: {
                return HttpStatus.UNAUTHORIZED.getCode();
            }
            case RESOURCE_EXHAUSTED: {
                return HttpStatus.TOO_MANY_REQUESTS.getCode();
            }
            case UNIMPLEMENTED: {
                return HttpStatus.NOT_IMPLEMENTED.getCode();
            }
            case UNAVAILABLE: {
                return HttpStatus.SERVICE_UNAVAILABLE.getCode();
            }
        }
        return HttpStatus.INTERNAL_SERVER_ERROR.getCode();
    }
}

