/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cli.profile;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.ToString;
import io.micronaut.cli.config.NavigableMap;
import io.micronaut.cli.interactive.completers.StringsCompleter;
import io.micronaut.cli.io.IOUtils;
import io.micronaut.cli.io.support.Resource;
import io.micronaut.cli.profile.Command;
import io.micronaut.cli.profile.DefaultFeature;
import io.micronaut.cli.profile.ExecutionContext;
import io.micronaut.cli.profile.Feature;
import io.micronaut.cli.profile.OneOfFeature;
import io.micronaut.cli.profile.Profile;
import io.micronaut.cli.profile.ProfileCommand;
import io.micronaut.cli.profile.ProfileRepository;
import io.micronaut.cli.profile.ProfileRepositoryAware;
import io.micronaut.cli.profile.ProjectContext;
import io.micronaut.cli.profile.ProjectContextAware;
import io.micronaut.cli.profile.commands.CommandRegistry;
import io.micronaut.cli.profile.commands.PicocliCompleter;
import io.micronaut.cli.profile.commands.script.GroovyScriptCommand;
import io.micronaut.cli.util.CliSettings;
import io.micronaut.cli.util.VersionInfo;
import java.io.File;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jline.console.completer.Completer;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.util.graph.selector.ExclusionDependencySelector;
import org.yaml.snakeyaml.Yaml;
import picocli.CommandLine;

@ToString(includes={"name"})
public abstract class AbstractProfile
implements Profile,
GroovyObject {
    protected final Resource profileDir;
    protected String name;
    protected List<Profile> parentProfiles;
    protected Map<String, Command> commandsByName;
    protected NavigableMap navigableConfig;
    protected ProfileRepository profileRepository;
    protected List<Dependency> dependencies;
    protected List<String> repositories;
    protected List<String> jvmArgs;
    protected List<String> parentNames;
    protected List<String> buildRepositories;
    protected List<String> buildPlugins;
    protected List<String> buildExcludes;
    protected List<String> skeletonExcludes;
    protected List<String> binaryExtensions;
    protected List<String> executablePatterns;
    protected final List<Command> internalCommands;
    protected List<String> buildMerge;
    protected List<Feature> features;
    protected Set<String> defaultFeaturesNames;
    protected Set<String> requiredFeatureNames;
    protected List<Map> oneOfFeatureMaps;
    protected String parentTargetFolder;
    protected final ClassLoader classLoader;
    protected ExclusionDependencySelector exclusionDependencySelector;
    protected String description;
    protected String instructions;
    protected String version;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public AbstractProfile(Resource profileDir) {
        this(profileDir, AbstractProfile.class.getClassLoader());
    }

    public AbstractProfile(Resource profileDir, ClassLoader classLoader) {
        Resource resource;
        ClassLoader classLoader2;
        MetaClass metaClass;
        String string;
        String string2;
        String string3;
        ExclusionDependencySelector exclusionDependencySelector;
        List list;
        List list2;
        List list3;
        List list4;
        List list5;
        List list6;
        List list7;
        List list8;
        List list9;
        List list10;
        List list11;
        List list12;
        List list13;
        this.dependencies = list13 = ScriptBytecodeAdapter.createList(new Object[0]);
        this.repositories = list12 = ScriptBytecodeAdapter.createList(new Object[0]);
        this.jvmArgs = list11 = ScriptBytecodeAdapter.createList(new Object[0]);
        this.parentNames = list10 = ScriptBytecodeAdapter.createList(new Object[0]);
        this.buildRepositories = list9 = ScriptBytecodeAdapter.createList(new Object[0]);
        this.buildPlugins = list8 = ScriptBytecodeAdapter.createList(new Object[0]);
        this.buildExcludes = list7 = ScriptBytecodeAdapter.createList(new Object[0]);
        this.skeletonExcludes = list6 = ScriptBytecodeAdapter.createList(new Object[0]);
        this.binaryExtensions = list5 = ScriptBytecodeAdapter.createList(new Object[0]);
        this.executablePatterns = list4 = ScriptBytecodeAdapter.createList(new Object[0]);
        this.internalCommands = list3 = ScriptBytecodeAdapter.createList(new Object[0]);
        Object var14_14 = null;
        this.buildMerge = (List)ScriptBytecodeAdapter.castToType(var14_14, List.class);
        this.features = list2 = ScriptBytecodeAdapter.createList(new Object[0]);
        List list14 = ScriptBytecodeAdapter.createList(new Object[0]);
        this.defaultFeaturesNames = (Set)ScriptBytecodeAdapter.castToType(list14, Set.class);
        List list15 = ScriptBytecodeAdapter.createList(new Object[0]);
        this.requiredFeatureNames = (Set)ScriptBytecodeAdapter.castToType(list15, Set.class);
        this.oneOfFeatureMaps = list = ScriptBytecodeAdapter.createList(new Object[0]);
        this.exclusionDependencySelector = exclusionDependencySelector = new ExclusionDependencySelector();
        this.description = string3 = "";
        this.instructions = string2 = "";
        this.version = string = VersionInfo.getVersion(CliSettings.class);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.classLoader = classLoader2 = classLoader;
        this.profileDir = resource = profileDir;
        URL url = profileDir.getURL();
        File jarFile = IOUtils.findJarFile(url);
        Pattern pattern = (Pattern)ScriptBytecodeAdapter.castToType(ScriptBytecodeAdapter.bitwiseNegate(".+-(\\d.+)\\.jar"), Pattern.class);
        String path = null;
        if (jarFile != null) {
            String string4;
            path = string4 = jarFile.getName();
        } else if (url != null) {
            String string5;
            String p = url.getPath();
            path = string5 = p.substring(0, p.indexOf(".jar") + 4);
        }
        if (DefaultTypeTransformation.booleanUnbox(path)) {
            Matcher matcher = pattern.matcher(path);
            if (matcher.matches()) {
                String string6;
                this.version = string6 = matcher.group(1);
            }
        }
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    protected void initialize() {
        List list;
        List list2;
        List list3;
        String string;
        List list4;
        List list5;
        List list6;
        List list7;
        List list8;
        List list9;
        NavigableMap navigableMap;
        String string2;
        String string3;
        String string4;
        Resource profileYml = this.profileDir.createRelative("profile.yml");
        Map profileConfig = new Yaml().loadAs(profileYml.getInputStream(), Map.class);
        Object v = profileConfig.get("name");
        this.name = string4 = v != null ? DefaultGroovyMethods.toString(v) : null;
        Object v2 = profileConfig.get("description");
        String string5 = v2 != null ? DefaultGroovyMethods.toString(v2) : null;
        this.description = string3 = DefaultTypeTransformation.booleanUnbox(string5) ? string5 : "";
        Object v3 = profileConfig.get("instructions");
        String string6 = v3 != null ? DefaultGroovyMethods.toString(v3) : null;
        this.instructions = string2 = DefaultTypeTransformation.booleanUnbox(string6) ? string6 : "";
        Object parents = profileConfig.get("extends");
        if (DefaultTypeTransformation.booleanUnbox(parents)) {
            public final class _initialize_closure1
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _initialize_closure1(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(String name) {
                    return name.trim();
                }

                public Object call(String name) {
                    return this.doCall(name);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (this.getClass() != _initialize_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass(this);
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            List list10 = DefaultGroovyMethods.collect((Object[])ScriptBytecodeAdapter.castToType(DefaultGroovyMethods.toString(parents).split(","), Object[].class), new _initialize_closure1(this, this));
            this.parentNames = list10;
        }
        if (this.name == null) {
            throw (Throwable)new IllegalStateException(ShortTypeHandling.castToString(new GStringImpl(new Object[]{this.profileDir.getURL()}, new String[]{"Profile name not set. Profile for path ", " is invalid"})));
        }
        NavigableMap map = new NavigableMap();
        map.merge(profileConfig);
        this.navigableConfig = navigableMap = map;
        Object commandsByName = profileConfig.get("commands");
        if (commandsByName instanceof Map) {
            Map commandsMap = (Map)ScriptBytecodeAdapter.castToType(commandsByName, Map.class);
            Object clsName22 = null;
            for (Object clsName22 : commandsMap.keySet()) {
                ProfileRepository profileRepository;
                AbstractProfile abstractProfile;
                String fileName = DefaultGroovyMethods.toString(DefaultGroovyMethods.getAt(commandsMap, clsName22));
                if (!fileName.endsWith(".groovy")) continue;
                GroovyScriptCommand cmd = (GroovyScriptCommand)ScriptBytecodeAdapter.castToType(DefaultGroovyMethods.newInstance(this.classLoader.loadClass(DefaultGroovyMethods.toString(clsName22))), GroovyScriptCommand.class);
                cmd.setProfile(abstractProfile);
                cmd.setProfileRepository(profileRepository);
                this.internalCommands.add(cmd);
            }
        }
        Object featuresConfig = profileConfig.get("features");
        if (featuresConfig instanceof Map) {
            Map featureMap = (Map)ScriptBytecodeAdapter.castToType(featuresConfig, Map.class);
            List<Object> list11 = (List<Object>)ScriptBytecodeAdapter.castToType(featureMap.get("provided"), List.class);
            List<Object> featureList = DefaultTypeTransformation.booleanUnbox(list11) ? list11 : Collections.emptyList();
            List list12 = (List)ScriptBytecodeAdapter.castToType(featureMap.get("defaults"), List.class);
            List defaultFeatures = DefaultTypeTransformation.booleanUnbox(list12) ? list12 : Collections.emptyList();
            List list13 = (List)ScriptBytecodeAdapter.castToType(featureMap.get("required"), List.class);
            List requiredFeatures = DefaultTypeTransformation.booleanUnbox(list13) ? list13 : Collections.emptyList();
            List<Map> list14 = (List<Map>)ScriptBytecodeAdapter.castToType(featureMap.get("oneOf"), List.class);
            List<Map> oneOfFeaturesMap = DefaultTypeTransformation.booleanUnbox(list14) ? list14 : Collections.emptyList();
            Object fn22 = null;
            for (Object fn22 : featureList) {
                Resource featureData = this.profileDir.createRelative(ShortTypeHandling.castToString(new GStringImpl(new Object[]{fn22}, new String[]{"features/", "/feature.yml"})));
                if (!featureData.exists()) continue;
                DefaultFeature f = new DefaultFeature(this, DefaultGroovyMethods.toString(fn22), this.profileDir.createRelative(ShortTypeHandling.castToString(new GStringImpl(new Object[]{fn22}, new String[]{"features/", "/"}))));
                this.features.add(f);
            }
            Map entry22 = null;
            for (Map entry22 : oneOfFeaturesMap) {
                if (!(entry22 instanceof Map)) continue;
                String feature = ShortTypeHandling.castToString(entry22.get("feature"));
                Integer priority = (Integer)ScriptBytecodeAdapter.castToType(entry22.get("priority"), Integer.class);
                this.oneOfFeatureMaps.add(ScriptBytecodeAdapter.createMap(new Object[]{"name", feature, "priority", priority}));
            }
            this.defaultFeaturesNames.addAll(defaultFeatures);
            this.requiredFeatureNames.addAll(requiredFeatures);
        }
        Object dependencyMap = profileConfig.get("dependencies");
        if (dependencyMap instanceof List) {
            List exclusions = ScriptBytecodeAdapter.createList(new Object[0]);
            Map entry32 = null;
            for (Map entry32 : (List)ScriptBytecodeAdapter.castToType(dependencyMap, List.class)) {
                ExclusionDependencySelector exclusionDependencySelector;
                if (entry32 instanceof Map) {
                    String scope = ShortTypeHandling.castToString(entry32.get("scope"));
                    String coords = ShortTypeHandling.castToString(entry32.get("coords"));
                    if ("excludes".equals(scope)) {
                        DefaultArtifact artifact = new DefaultArtifact(coords);
                        String string7 = artifact.getArtifactId();
                        String string8 = artifact.getClassifier();
                        String string9 = artifact.getExtension();
                        String string10 = artifact.getGroupId();
                        exclusions.add(new Exclusion(ShortTypeHandling.castToString(DefaultTypeTransformation.booleanUnbox(string10) ? string10 : null), ShortTypeHandling.castToString(DefaultTypeTransformation.booleanUnbox(string7) ? string7 : null), ShortTypeHandling.castToString(DefaultTypeTransformation.booleanUnbox(string8) ? string8 : null), ShortTypeHandling.castToString(DefaultTypeTransformation.booleanUnbox(string9) ? string9 : null)));
                    } else {
                        if (StringGroovyMethods.count((CharSequence)coords, (CharSequence)":") == 1) {
                            GStringImpl gStringImpl = new GStringImpl(new Object[]{coords}, new String[]{"", ":BOM"});
                            coords = ShortTypeHandling.castToString(gStringImpl);
                        }
                        Dependency dependency = new Dependency(new DefaultArtifact(coords), scope.toString());
                        if (entry32.containsKey("excludes")) {
                            Dependency dependency2;
                            ArrayList<Exclusion> dependencyExclusions = new ArrayList<Exclusion>();
                            List excludes = (List)ScriptBytecodeAdapter.castToType(entry32.get("excludes"), List.class);
                            Map ex22 = null;
                            for (Map ex22 : excludes) {
                                if (!(ex22 instanceof Map)) continue;
                                dependencyExclusions.add(new Exclusion(ShortTypeHandling.castToString(ex22.get("group")), ShortTypeHandling.castToString(ex22.get("module")), ShortTypeHandling.castToString(ex22.get("classifier")), ShortTypeHandling.castToString(ex22.get("extension"))));
                            }
                            dependency = dependency2 = dependency.setExclusions(dependencyExclusions);
                        }
                        this.dependencies.add(dependency);
                    }
                }
                this.exclusionDependencySelector = exclusionDependencySelector = new ExclusionDependencySelector(exclusions);
            }
        }
        this.repositories = list9 = (List)ScriptBytecodeAdapter.castToType(DefaultGroovyMethods.get(this.navigableConfig, "repositories", ScriptBytecodeAdapter.createList(new Object[0])), List.class);
        this.jvmArgs = list8 = (List)ScriptBytecodeAdapter.castToType(DefaultGroovyMethods.get(this.navigableConfig, "jvmArgs", ScriptBytecodeAdapter.createList(new Object[0])), List.class);
        this.buildRepositories = list7 = (List)ScriptBytecodeAdapter.castToType(DefaultGroovyMethods.get(this.navigableConfig, "build.repositories", ScriptBytecodeAdapter.createList(new Object[0])), List.class);
        this.buildPlugins = list6 = (List)ScriptBytecodeAdapter.castToType(DefaultGroovyMethods.get(this.navigableConfig, "build.plugins", ScriptBytecodeAdapter.createList(new Object[0])), List.class);
        this.buildExcludes = list5 = (List)ScriptBytecodeAdapter.castToType(DefaultGroovyMethods.get(this.navigableConfig, "build.excludes", ScriptBytecodeAdapter.createList(new Object[0])), List.class);
        this.buildMerge = list4 = (List)ScriptBytecodeAdapter.castToType(DefaultGroovyMethods.get(this.navigableConfig, "build.merge", null), List.class);
        this.parentTargetFolder = string = ShortTypeHandling.castToString(DefaultGroovyMethods.get(this.navigableConfig, "skeleton.parent.target", null));
        this.skeletonExcludes = list3 = (List)ScriptBytecodeAdapter.castToType(DefaultGroovyMethods.get(this.navigableConfig, "skeleton.excludes", ScriptBytecodeAdapter.createList(new Object[0])), List.class);
        this.binaryExtensions = list2 = (List)ScriptBytecodeAdapter.castToType(DefaultGroovyMethods.get(this.navigableConfig, "skeleton.binaryExtensions", ScriptBytecodeAdapter.createList(new Object[0])), List.class);
        this.executablePatterns = list = (List)ScriptBytecodeAdapter.castToType(DefaultGroovyMethods.get(this.navigableConfig, "skeleton.executable", ScriptBytecodeAdapter.createList(new Object[0])), List.class);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getInstructions() {
        return this.instructions;
    }

    @Override
    public Set<String> getBinaryExtensions() {
        Set calculatedBinaryExtensions = (Set)ScriptBytecodeAdapter.castToType(ScriptBytecodeAdapter.createList(new Object[0]), Set.class);
        Iterable<Profile> parents = this.getExtends();
        Profile profile = null;
        Iterator<Profile> iterator = parents.iterator();
        while (iterator.hasNext()) {
            profile = (Profile)ScriptBytecodeAdapter.castToType(iterator.next(), Profile.class);
            calculatedBinaryExtensions.addAll(profile.getBinaryExtensions());
        }
        calculatedBinaryExtensions.addAll(this.binaryExtensions);
        return calculatedBinaryExtensions;
    }

    @Override
    public Set<String> getExecutablePatterns() {
        Set calculatedExecutablePatterns = (Set)ScriptBytecodeAdapter.castToType(ScriptBytecodeAdapter.createList(new Object[0]), Set.class);
        Iterable<Profile> parents = this.getExtends();
        Profile profile = null;
        Iterator<Profile> iterator = parents.iterator();
        while (iterator.hasNext()) {
            profile = (Profile)ScriptBytecodeAdapter.castToType(iterator.next(), Profile.class);
            calculatedExecutablePatterns.addAll(profile.getExecutablePatterns());
        }
        calculatedExecutablePatterns.addAll(this.executablePatterns);
        return calculatedExecutablePatterns;
    }

    @Override
    public Iterable<Feature> getDefaultFeatures() {
        public final class _getDefaultFeatures_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getDefaultFeatures_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Feature f) {
                return ((Set)this.getProperty("defaultFeaturesNames")).contains(f.getName());
            }

            public Object call(Feature f) {
                return this.doCall(f);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _getDefaultFeatures_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultGroovyMethods.findAll(this.getFeatures(), (Closure)new _getDefaultFeatures_closure2(this, this));
    }

    @Override
    public Iterable<OneOfFeature> getOneOfFeatures() {
        CallSite[] callSiteArray = AbstractProfile.$getCallSiteArray();
        List features = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[0].call(callSiteArray[1].callCurrent(this));
            features = (List)ScriptBytecodeAdapter.castToType(object, List.class);
        } else {
            Object object = callSiteArray[2].call(this.getFeatures());
            features = (List)ScriptBytecodeAdapter.castToType(object, List.class);
        }
        List oneOfFeatures = ScriptBytecodeAdapter.createList(new Object[0]);
        Reference<Object> map = new Reference<Object>(null);
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType(callSiteArray[3].call(this.oneOfFeatureMaps), Iterator.class);
        while (iterator.hasNext()) {
            map.set(((Map)ScriptBytecodeAdapter.castToType(iterator.next(), Map.class)));
            public final class _getOneOfFeatures_closure3
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference map;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _getOneOfFeatures_closure3(Object _outerInstance, Object _thisObject, Reference map) {
                    Reference reference;
                    CallSite[] callSiteArray = _getOneOfFeatures_closure3.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.map = reference = map;
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _getOneOfFeatures_closure3.$getCallSiteArray();
                    return ScriptBytecodeAdapter.compareEqual(callSiteArray[0].callGetProperty(it), callSiteArray[1].callGetProperty(this.map.get()));
                }

                public Map getMap() {
                    CallSite[] callSiteArray = _getOneOfFeatures_closure3.$getCallSiteArray();
                    return (Map)ScriptBytecodeAdapter.castToType(this.map.get(), Map.class);
                }

                public Object doCall() {
                    CallSite[] callSiteArray = _getOneOfFeatures_closure3.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (this.getClass() != _getOneOfFeatures_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass(this);
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "name";
                    stringArray[1] = "name";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[2];
                    _getOneOfFeatures_closure3.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_getOneOfFeatures_closure3.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _getOneOfFeatures_closure3.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            Feature f = (Feature)ScriptBytecodeAdapter.castToType(callSiteArray[4].call((Object)features, new _getOneOfFeatures_closure3(this, this, map)), Feature.class);
            if (!DefaultTypeTransformation.booleanUnbox(f)) continue;
            callSiteArray[5].call((Object)oneOfFeatures, callSiteArray[6].callConstructor(OneOfFeature.class, ScriptBytecodeAdapter.createMap(new Object[]{"feature", f, "priority", (Integer)ScriptBytecodeAdapter.castToType(callSiteArray[7].callGetProperty(map.get()), Integer.class)})));
        }
        public final class _getOneOfFeatures_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getOneOfFeatures_closure4(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _getOneOfFeatures_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object a, Object b) {
                CallSite[] callSiteArray = _getOneOfFeatures_closure4.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareTo(callSiteArray[0].callGetProperty(a), callSiteArray[1].callGetProperty(b));
            }

            public Object call(Object a, Object b) {
                CallSite[] callSiteArray = _getOneOfFeatures_closure4.$getCallSiteArray();
                return callSiteArray[2].callCurrent(this, a, b);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _getOneOfFeatures_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "priority";
                stringArray[1] = "priority";
                stringArray[2] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _getOneOfFeatures_closure4.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getOneOfFeatures_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getOneOfFeatures_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Iterable)ScriptBytecodeAdapter.castToType(callSiteArray[8].call((Object)oneOfFeatures, new _getOneOfFeatures_closure4(this, this)), Iterable.class);
    }

    @Override
    public Iterable<Feature> getRequiredFeatures() {
        public final class _getRequiredFeatures_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getRequiredFeatures_closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Feature f) {
                return ((Set)this.getProperty("requiredFeatureNames")).contains(f.getName());
            }

            public Object call(Feature f) {
                return this.doCall(f);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _getRequiredFeatures_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Collection requiredFeatureInstances = DefaultGroovyMethods.findAll(this.getFeatures(), (Closure)new _getRequiredFeatures_closure5(this, this));
        if (requiredFeatureInstances.size() != this.requiredFeatureNames.size()) {
            throw (Throwable)new IllegalStateException(ShortTypeHandling.castToString(new GStringImpl(new Object[]{this.requiredFeatureNames}, new String[]{"One or more required features were not found on the classpath. Required features: ", ""})));
        }
        return requiredFeatureInstances;
    }

    @Override
    public Iterable<Feature> getFeatures() {
        Set calculatedFeatures = (Set)ScriptBytecodeAdapter.castToType(ScriptBytecodeAdapter.createList(new Object[0]), Set.class);
        calculatedFeatures.addAll(this.features);
        Iterable<Profile> parents = this.getExtends();
        Profile profile = null;
        Iterator<Profile> iterator = parents.iterator();
        while (iterator.hasNext()) {
            profile = (Profile)ScriptBytecodeAdapter.castToType(iterator.next(), Profile.class);
            DefaultGroovyMethods.addAll(calculatedFeatures, profile.getFeatures());
        }
        return calculatedFeatures;
    }

    @Override
    public List<String> getBuildMergeProfileNames() {
        if (this.buildMerge != null) {
            return this.buildMerge;
        }
        List mergeNames = ScriptBytecodeAdapter.createList(new Object[0]);
        Profile parent = null;
        Iterator<Profile> iterator = this.getExtends().iterator();
        while (iterator.hasNext()) {
            parent = (Profile)ScriptBytecodeAdapter.castToType(iterator.next(), Profile.class);
            mergeNames.add(parent.getName());
        }
        mergeNames.add(this.name);
        return mergeNames;
    }

    @Override
    public List<String> getBuildRepositories() {
        List calculatedRepositories = ScriptBytecodeAdapter.createList(new Object[0]);
        if (this.buildRepositories.isEmpty()) {
            Iterable<Profile> parents = this.getExtends();
            Profile profile = null;
            Iterator<Profile> iterator = parents.iterator();
            while (iterator.hasNext()) {
                profile = (Profile)ScriptBytecodeAdapter.castToType(iterator.next(), Profile.class);
                calculatedRepositories.addAll(profile.getBuildRepositories());
            }
        } else {
            calculatedRepositories.addAll(this.buildRepositories);
        }
        return calculatedRepositories;
    }

    @Override
    public List<String> getBuildPlugins() {
        List calculatedPlugins = ScriptBytecodeAdapter.createList(new Object[0]);
        Iterable<Profile> parents = this.getExtends();
        Profile profile = null;
        Iterator<Profile> iterator = parents.iterator();
        while (iterator.hasNext()) {
            profile = (Profile)ScriptBytecodeAdapter.castToType(iterator.next(), Profile.class);
            List<String> dependencies = profile.getBuildPlugins();
            String dep = null;
            Iterator<String> iterator2 = dependencies.iterator();
            while (iterator2.hasNext()) {
                dep = ShortTypeHandling.castToString(iterator2.next());
                if (!(!this.buildExcludes.contains(dep))) continue;
                calculatedPlugins.add(dep);
            }
        }
        calculatedPlugins.addAll(this.buildPlugins);
        return calculatedPlugins;
    }

    @Override
    public List<String> getRepositories() {
        List calculatedRepositories = ScriptBytecodeAdapter.createList(new Object[0]);
        if (this.repositories.isEmpty()) {
            Iterable<Profile> parents = this.getExtends();
            Profile profile = null;
            Iterator<Profile> iterator = parents.iterator();
            while (iterator.hasNext()) {
                profile = (Profile)ScriptBytecodeAdapter.castToType(iterator.next(), Profile.class);
                calculatedRepositories.addAll(profile.getRepositories());
            }
        } else {
            calculatedRepositories.addAll(this.repositories);
        }
        return calculatedRepositories;
    }

    @Override
    public List<String> getJvmArgs() {
        return this.jvmArgs;
    }

    @Override
    public List<Dependency> getDependencies() {
        List calculatedDependencies = ScriptBytecodeAdapter.createList(new Object[0]);
        Iterable<Profile> parents = this.getExtends();
        Profile profile = null;
        Iterator<Profile> iterator = parents.iterator();
        while (iterator.hasNext()) {
            profile = (Profile)ScriptBytecodeAdapter.castToType(iterator.next(), Profile.class);
            List<Dependency> dependencies = profile.getDependencies();
            Dependency dep = null;
            Iterator<Dependency> iterator2 = dependencies.iterator();
            while (iterator2.hasNext()) {
                dep = (Dependency)ScriptBytecodeAdapter.castToType(iterator2.next(), Dependency.class);
                if (!this.exclusionDependencySelector.selectDependency(dep)) continue;
                calculatedDependencies.add(dep);
            }
        }
        calculatedDependencies.addAll(this.dependencies);
        return calculatedDependencies;
    }

    public ProfileRepository getProfileRepository() {
        return this.profileRepository;
    }

    public void setProfileRepository(ProfileRepository profileRepository) {
        ProfileRepository profileRepository2;
        this.profileRepository = profileRepository2 = profileRepository;
    }

    @Override
    public Resource getProfileDir() {
        return this.profileDir;
    }

    @Override
    public NavigableMap getConfiguration() {
        return this.navigableConfig;
    }

    @Override
    public Resource getTemplate(String path) {
        return this.profileDir.createRelative(ShortTypeHandling.castToString(new GStringImpl(new Object[]{path}, new String[]{"templates/", ""})));
    }

    @Override
    public Iterable<Profile> getExtends() {
        public final class _getExtends_closure6
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getExtends_closure6(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(String name) {
                Profile parent = ((AbstractProfile)ScriptBytecodeAdapter.castToType(this.getThisObject(), AbstractProfile.class)).getProfileRepository().getProfile(name, true);
                if (parent == null) {
                    throw (Throwable)new IllegalStateException(ShortTypeHandling.castToString(new GStringImpl(new Object[]{name, name}, new String[]{"Profile [", "] declares an invalid dependency on parent profile [", "]"})));
                }
                return parent;
            }

            public Object call(String name) {
                return this.doCall(name);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _getExtends_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultGroovyMethods.collect(this.parentNames, new _getExtends_closure6(this, this));
    }

    @Override
    public Iterable<Completer> getCompleters(ProjectContext context) {
        Iterable<Command> commands = this.getCommands(context);
        List completers = ScriptBytecodeAdapter.createList(new Object[0]);
        Command cmd = null;
        Iterator<Command> iterator = commands.iterator();
        while (iterator.hasNext()) {
            cmd = (Command)ScriptBytecodeAdapter.castToType(iterator.next(), Command.class);
            DefaultGroovyMethods.leftShift(completers, new StringsCompleter(cmd.getName()));
            DefaultGroovyMethods.leftShift(completers, new PicocliCompleter(cmd.getCommandSpec()));
        }
        return completers;
    }

    @Override
    public Command getCommand(ProjectContext context, String name) {
        this.getCommands(context);
        return (Command)ScriptBytecodeAdapter.castToType(DefaultGroovyMethods.getAt(this.commandsByName, name), Command.class);
    }

    @Override
    public Iterable<Command> getCommands(ProjectContext context) {
        Reference<ProjectContext> context2 = new Reference<ProjectContext>(context);
        if (this.commandsByName == null) {
            Map map = ScriptBytecodeAdapter.createMap(new Object[0]);
            this.commandsByName = (LinkedHashMap)ScriptBytecodeAdapter.castToType(map, LinkedHashMap.class);
            Reference<List> excludes = new Reference<List>(ScriptBytecodeAdapter.createList(new Object[0]));
            public final class _getCommands_closure7
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference excludes;
                private /* synthetic */ Reference context;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getCommands_closure7(Object _outerInstance, Object _thisObject, Reference excludes, Reference context) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    this.excludes = reference2 = excludes;
                    this.context = reference = context;
                }

                public Object doCall(Command command) {
                    new CommandLine(command);
                    String name = command.getName();
                    if (!((Map)this.getProperty("commandsByName")).containsKey(name) && !((List)this.excludes.get()).contains(name)) {
                        if (command instanceof ProfileRepositoryAware) {
                            ((ProfileRepositoryAware)ScriptBytecodeAdapter.castToType(command, ProfileRepositoryAware.class)).setProfileRepository(((AbstractProfile)ScriptBytecodeAdapter.castToType(this.getThisObject(), AbstractProfile.class)).getProfileRepository());
                        }
                        Command command2 = command;
                        DefaultGroovyMethods.putAt((Map)ScriptBytecodeAdapter.castToType(this.getProperty("commandsByName"), Map.class), name, command2);
                        CommandLine.Model.CommandSpec desc = command.getCommandSpec();
                        CommandLine.Model.CommandSpec commandSpec = desc;
                        String[] synonyms = commandSpec != null ? commandSpec.aliases() : null;
                        if (DefaultTypeTransformation.booleanUnbox(synonyms)) {
                            String syn2 = null;
                            String[] stringArray = synonyms;
                            if (synonyms != null) {
                                for (String syn2 : stringArray) {
                                    Command command3 = command;
                                    DefaultGroovyMethods.putAt((Map)ScriptBytecodeAdapter.castToType(this.getProperty("commandsByName"), Map.class), syn2, command3);
                                }
                            }
                        }
                        if (command instanceof ProjectContextAware) {
                            Object t = this.context.get();
                            ((ProjectContextAware)ScriptBytecodeAdapter.castToType(command, ProjectContextAware.class)).setProjectContext((ProjectContext)ScriptBytecodeAdapter.castToType(t, ProjectContext.class));
                        }
                        if (command instanceof ProfileCommand) {
                            AbstractProfile abstractProfile = (AbstractProfile)this.getThisObject();
                            ((ProfileCommand)ScriptBytecodeAdapter.castToType(command, ProfileCommand.class)).setProfile(abstractProfile);
                            return abstractProfile;
                        }
                        return null;
                    }
                    return null;
                }

                public Object call(Command command) {
                    return this.doCall(command);
                }

                public List getExcludes() {
                    return (List)ScriptBytecodeAdapter.castToType(this.excludes.get(), List.class);
                }

                public ProjectContext getContext() {
                    return (ProjectContext)ScriptBytecodeAdapter.castToType(this.context.get(), ProjectContext.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (this.getClass() != _getCommands_closure7.class) {
                        return ScriptBytecodeAdapter.initMetaClass(this);
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            _getCommands_closure7 registerCommand = new _getCommands_closure7(this, this, excludes, context2);
            DefaultGroovyMethods.each(CommandRegistry.findCommands(this), (Closure)registerCommand);
            Iterable<Profile> parents = this.getExtends();
            if (DefaultTypeTransformation.booleanUnbox(parents)) {
                List list = (List)ScriptBytecodeAdapter.castToType(this.getConfiguration().navigate("command", "excludes"), List.class);
                List list2 = DefaultTypeTransformation.booleanUnbox(list) ? list : ScriptBytecodeAdapter.createList(new Object[0]);
                excludes.set(list2);
                this.registerParentCommands(context2.get(), parents, registerCommand);
            }
        }
        return this.commandsByName.values();
    }

    protected void registerParentCommands(ProjectContext context, Iterable<Profile> parents, Closure registerCommand) {
        Profile parent = null;
        Iterator<Profile> iterator = parents.iterator();
        while (iterator.hasNext()) {
            parent = (Profile)ScriptBytecodeAdapter.castToType(iterator.next(), Profile.class);
            DefaultGroovyMethods.each(parent.getCommands(context), registerCommand);
            Iterable<Profile> extended = parent.getExtends();
            if (!DefaultTypeTransformation.booleanUnbox(extended)) continue;
            this.registerParentCommands(context, extended, registerCommand);
        }
    }

    @Override
    public boolean hasCommand(ProjectContext context, String name) {
        this.getCommands(context);
        return this.commandsByName.containsKey(name);
    }

    @Override
    public boolean handleCommand(ExecutionContext context) {
        CommandLine.ParseResult parseResult = context.getParseResult();
        while (parseResult.hasSubcommand()) {
            CommandLine.ParseResult parseResult2;
            parseResult = parseResult2 = parseResult.subcommand();
        }
        Command cmd = (Command)ScriptBytecodeAdapter.asType(parseResult.commandSpec().userObject(), Command.class);
        return cmd.handle(context);
    }

    @Override
    public String getParentSkeletonDir() {
        return this.parentTargetFolder;
    }

    @Override
    public File getParentSkeletonDir(File parent) {
        if (DefaultTypeTransformation.booleanUnbox(this.getParentSkeletonDir())) {
            return new File(parent, this.getParentSkeletonDir());
        }
        return parent;
    }

    @Override
    public List<String> getSkeletonExcludes() {
        return this.skeletonExcludes;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AbstractProfile.class) {
            return ScriptBytecodeAdapter.initMetaClass(this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public String toString() {
        StringBuilder _result = new StringBuilder();
        Boolean $toStringFirst = Boolean.TRUE;
        _result.append("io.micronaut.cli.profile.AbstractProfile(");
        Boolean bl = $toStringFirst;
        if (bl == null ? false : bl) {
            Boolean bl2;
            $toStringFirst = bl2 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append(InvokerHelper.toString(this.name));
        _result.append(")");
        return _result.toString();
    }

    @Override
    @Generated
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Override
    @Generated
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Override
    @Generated
    public Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Override
    @Generated
    public Object getProperty(String string) {
        return this.getMetaClass().getProperty(this, string);
    }

    @Override
    @Generated
    public void setProperty(String string, Object object) {
        this.getMetaClass().setProperty(this, string, object);
    }

    public /* synthetic */ String super$1$toString() {
        return super.toString();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "toList";
        stringArray[1] = "getFeatures";
        stringArray[2] = "toList";
        stringArray[3] = "iterator";
        stringArray[4] = "find";
        stringArray[5] = "add";
        stringArray[6] = "<$constructor$>";
        stringArray[7] = "priority";
        stringArray[8] = "sort";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[9];
        AbstractProfile.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(AbstractProfile.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = AbstractProfile.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

