/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.coherence.data;

import com.oracle.coherence.repository.AbstractAsyncRepository;
import com.tangosol.net.AsyncNamedMap;
import io.micronaut.coherence.data.annotation.AsyncPersistEventSource;
import io.micronaut.coherence.data.annotation.AsyncRemoveEventSource;
import io.micronaut.coherence.data.interceptors.GetAsyncMapInterceptor;
import io.micronaut.coherence.data.interceptors.GetEntityTypeInterceptor;
import io.micronaut.coherence.data.interceptors.GetIdInterceptor;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.repository.GenericRepository;
import java.util.concurrent.CompletableFuture;

public abstract class AbstractCoherenceAsyncRepository<T, ID>
extends AbstractAsyncRepository<ID, T>
implements GenericRepository<T, ID> {
    protected AsyncNamedMap<ID, T> getMap() {
        return this.getMapInternal();
    }

    protected ID getId(T t) {
        return this.getIdInternal(t);
    }

    protected Class<? extends T> getEntityType() {
        return this.getEntityTypeInternal(null);
    }

    @AsyncPersistEventSource
    public CompletableFuture<T> save(T entity) {
        return super.save(entity);
    }

    @AsyncRemoveEventSource
    public CompletableFuture<Boolean> remove(T entity) {
        return super.remove(entity);
    }

    @DataMethod(interceptor=GetIdInterceptor.class)
    protected abstract ID getIdInternal(T var1);

    @DataMethod(interceptor=GetAsyncMapInterceptor.class)
    protected abstract AsyncNamedMap<ID, T> getMapInternal();

    @DataMethod(interceptor=GetEntityTypeInterceptor.class)
    protected abstract Class<? extends T> getEntityTypeInternal(T var1);
}

