/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.coherence.data.interceptors;

import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.data.event.EntityEventContext;
import io.micronaut.data.model.runtime.EntityInstanceOperation;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.event.DefaultEntityEventContext;

public abstract class AbstractEventSourceInterceptor
implements MethodInterceptor {
    protected RuntimeEntityRegistry registry;

    protected AbstractEventSourceInterceptor(RuntimeEntityRegistry registry) {
        this.registry = registry;
    }

    public Object intercept(MethodInvocationContext context) {
        Object[] parameters = context.getParameterValues();
        if (parameters.length == 1) {
            Object eventFor = parameters[0];
            if (eventFor instanceof EntityInstanceOperation) {
                eventFor = ((EntityInstanceOperation)eventFor).getEntity();
            }
            if (!this.trigger(this.getHandledPreEventType(), eventFor)) {
                switch (this.getEventGroup()) {
                    case REMOVE: {
                        Object target = context.getTarget();
                        if (target instanceof RepositoryOperations) {
                            return 0;
                        }
                        return false;
                    }
                }
                return eventFor;
            }
            Object result = context.proceed();
            this.trigger(this.getHandledPostEventType(), eventFor.getClass().isInstance(result) ? result : eventFor);
            return result;
        }
        return context.proceed();
    }

    public abstract EventGroup getEventGroup();

    public abstract EventType getHandledPreEventType();

    public abstract EventType getHandledPostEventType();

    protected boolean trigger(EventType eventType, Object entity) {
        ArgumentUtils.requireNonNull((String)"eventType", (Object)((Object)eventType));
        ArgumentUtils.requireNonNull((String)"entity", (Object)((Object)eventType));
        RuntimePersistentEntity rpe = this.registry.getEntity(entity.getClass());
        switch (eventType) {
            case PRE_PERSIST: {
                if (!rpe.hasPrePersistEventListeners()) break;
                return this.registry.getEntityEventListener().prePersist((EntityEventContext)new DefaultEntityEventContext(rpe, entity));
            }
            case POST_PERSIST: {
                if (!rpe.hasPostPersistEventListeners()) break;
                this.registry.getEntityEventListener().postPersist((EntityEventContext)new DefaultEntityEventContext(rpe, entity));
                break;
            }
            case PRE_UPDATE: {
                if (!rpe.hasPreUpdateEventListeners()) break;
                return this.registry.getEntityEventListener().preUpdate((EntityEventContext)new DefaultEntityEventContext(rpe, entity));
            }
            case POST_UPDATE: {
                if (!rpe.hasPostUpdateEventListeners()) break;
                this.registry.getEntityEventListener().postUpdate((EntityEventContext)new DefaultEntityEventContext(rpe, entity));
                break;
            }
            case PRE_REMOVE: {
                if (!rpe.hasPreRemoveEventListeners()) break;
                return this.registry.getEntityEventListener().preRemove((EntityEventContext)new DefaultEntityEventContext(rpe, entity));
            }
            default: {
                if (!rpe.hasPostRemoveEventListeners()) break;
                this.registry.getEntityEventListener().postRemove((EntityEventContext)new DefaultEntityEventContext(rpe, entity));
            }
        }
        return true;
    }

    public static enum EventType {
        PRE_PERSIST,
        POST_PERSIST,
        PRE_UPDATE,
        POST_UPDATE,
        PRE_REMOVE,
        POST_REMOVE;

    }

    public static enum EventGroup {
        PERSIST,
        UPDATE,
        REMOVE;

    }
}

