/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.coherence.data.ops;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.coherence.dslquery.ExecutionContext;
import com.tangosol.coherence.dslquery.Statement;
import com.tangosol.net.NamedMap;
import com.tangosol.net.Session;
import com.tangosol.util.Processors;
import com.tangosol.util.QueryHelper;
import io.micronaut.coherence.data.annotation.PersistEventSource;
import io.micronaut.coherence.data.annotation.RemoveEventSource;
import io.micronaut.coherence.data.annotation.UpdateEventSource;
import io.micronaut.coherence.data.ops.CoherenceAsyncRepositoryOperations;
import io.micronaut.coherence.data.ops.CoherenceRepositoryOperations;
import io.micronaut.coherence.data.ops.DefaultCoherenceAsyncRepositoryOperations;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.runtime.DeleteBatchOperation;
import io.micronaut.data.model.runtime.DeleteOperation;
import io.micronaut.data.model.runtime.InsertBatchOperation;
import io.micronaut.data.model.runtime.InsertOperation;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.QueryParameterBinding;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.model.runtime.UpdateOperation;
import io.micronaut.data.operations.async.AsyncRepositoryOperations;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

@EachProperty(value="coherence.data")
public class DefaultCoherenceRepositoryOperations
implements CoherenceRepositoryOperations {
    private static final String LOG_QUERIES_PROPERTY = "coherence.data.query.log";
    private static final boolean LOG_QUERIES = Boolean.getBoolean("coherence.data.query.log");
    private static final String PAGING_QUERIES_ARE_NOT_SUPPORTED = "paging queries are not supported";
    private final String mapName;
    private final BeanContext beanContext;
    private final ConcurrentMap<Class<?>, RuntimePersistentEntity> entities = new ConcurrentHashMap(5);
    private String sessionName;
    private Session session;
    private NamedMap namedMap;
    private ExecutionContext cohQLContext;
    private final CoherenceAsyncRepositoryOperations asyncOperations;
    private final ApplicationContext applicationContext;

    public DefaultCoherenceRepositoryOperations(@Parameter String mapName, ApplicationContext applicationContext, BeanContext beanContext) {
        ArgumentUtils.requireNonNull((String)"mapName", (Object)mapName);
        ArgumentUtils.requireNonNull((String)"beanContext", (Object)beanContext);
        ArgumentUtils.requireNonNull((String)"applicationContext", (Object)beanContext);
        this.mapName = mapName;
        this.beanContext = beanContext;
        this.asyncOperations = (CoherenceAsyncRepositoryOperations)beanContext.createBean(DefaultCoherenceAsyncRepositoryOperations.class, new Object[]{this});
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Override
    public <ID, T> NamedMap<ID, T> getNamedMap() {
        return this.ensureNamedMap();
    }

    @Override
    public <ID, T> ID getId(T entity) {
        RuntimePersistentEntity rpe = this.ensureMeta(entity.getClass());
        RuntimePersistentProperty identityProp = rpe.getIdentity();
        assert (identityProp != null);
        BeanProperty beanProp = identityProp.getProperty();
        assert (beanProp != null);
        return (ID)identityProp.getProperty().get(entity);
    }

    protected void setSession(String sessionName) {
        ArgumentUtils.requireNonNull((String)"sessionName", (Object)sessionName);
        this.sessionName = sessionName;
    }

    @NonNull
    public AsyncRepositoryOperations async() {
        return this.asyncOperations;
    }

    @Nullable
    public <T> T findOne(@NonNull Class<T> type, @NonNull Serializable id) {
        return (T)this.getNamedMap().get((Object)id);
    }

    @Nullable
    public <T, R> R findOne(@NonNull PreparedQuery<T, R> preparedQuery) {
        Object result = this.execute(preparedQuery);
        if (result instanceof Map) {
            Map m = (Map)result;
            if (m.isEmpty()) {
                return null;
            }
            return m.values().stream().findFirst().orElse(null);
        }
        if (result instanceof Number) {
            return (R)result;
        }
        throw new IllegalStateException("Unhandled type: " + result.getClass().getName());
    }

    public <T> boolean exists(@NonNull PreparedQuery<T, Boolean> preparedQuery) {
        Map m = (Map)this.execute(preparedQuery);
        return !m.isEmpty();
    }

    @NonNull
    public <T> Iterable<T> findAll(@NonNull PagedQuery<T> query) {
        throw new UnsupportedOperationException(PAGING_QUERIES_ARE_NOT_SUPPORTED);
    }

    public <T> long count(PagedQuery<T> pagedQuery) {
        return this.getNamedMap().size();
    }

    @NonNull
    public <T, R> Iterable<R> findAll(@NonNull PreparedQuery<T, R> preparedQuery) {
        Object result = this.execute(preparedQuery);
        if (result instanceof Map) {
            Map m = (Map)result;
            return m.values();
        }
        if (result instanceof Number) {
            return Collections.singletonList(((Number)result).longValue());
        }
        if (result instanceof Iterable) {
            return (Iterable)result;
        }
        throw new IllegalStateException("Unhandled type: " + result.getClass().getName());
    }

    @NonNull
    public <T, R> Stream<R> findStream(@NonNull PreparedQuery<T, R> preparedQuery) {
        Map m = (Map)this.execute(preparedQuery);
        return m.values().stream();
    }

    @NonNull
    public <T> Stream<T> findStream(@NonNull PagedQuery<T> query) {
        throw new UnsupportedOperationException(PAGING_QUERIES_ARE_NOT_SUPPORTED);
    }

    public <R> Page<R> findPage(@NonNull PagedQuery<R> query) {
        throw new UnsupportedOperationException(PAGING_QUERIES_ARE_NOT_SUPPORTED);
    }

    @NonNull
    @PersistEventSource
    public <T> T persist(@NonNull InsertOperation<T> operation) {
        Object entity = operation.getEntity();
        this.getNamedMap().put(this.getId(entity), entity);
        return (T)entity;
    }

    @NonNull
    @UpdateEventSource
    public <T> T update(@NonNull UpdateOperation<T> operation) {
        Object entity = operation.getEntity();
        this.getNamedMap().put(this.getId(entity), entity);
        return (T)entity;
    }

    @NonNull
    public Optional<Number> executeUpdate(@NonNull PreparedQuery<?, Number> preparedQuery) {
        Object result = this.execute(preparedQuery);
        if (result instanceof Map) {
            return Optional.of(((Map)result).size());
        }
        if (result instanceof Set) {
            return Optional.of(((Set)result).size());
        }
        throw new IllegalStateException("unhandled return type");
    }

    public <T> Optional<Number> deleteAll(@NonNull DeleteBatchOperation<T> operation) {
        LinkedHashMap entitiesToDelete = new LinkedHashMap();
        operation.forEach(t -> entitiesToDelete.put(this.getId(t), t));
        Map result = this.getNamedMap().invokeAll(entitiesToDelete.keySet(), Processors.remove());
        return Optional.of(result.size());
    }

    @RemoveEventSource
    public <T> int delete(@NonNull DeleteOperation<T> operation) {
        Object entity = operation.getEntity();
        boolean removed = this.getNamedMap().remove(this.getId(entity), entity);
        return removed ? 1 : 0;
    }

    @NonNull
    public <T> Iterable<T> persistAll(@NonNull InsertBatchOperation<T> operation) {
        HashMap entitiesToSave = new HashMap();
        operation.forEach(t -> entitiesToSave.put(this.getId(t), t));
        this.getNamedMap().putAll(entitiesToSave);
        return entitiesToSave.values();
    }

    Statement createStatement(ExecutionContext context, PreparedQuery preparedQuery) {
        Map<String, Object> bindings = this.createBindingMap(preparedQuery);
        String query = this.replaceTarget(preparedQuery.getQuery(), preparedQuery.getRootEntity());
        Statement statement = QueryHelper.createStatement((String)query, (ExecutionContext)context, bindings);
        this.logQuery(context, statement, query, bindings);
        return statement;
    }

    private Object execute(PreparedQuery preparedQuery) {
        ExecutionContext ctx = this.ensureExecutionContext();
        Statement statement = this.createStatement(ctx, preparedQuery);
        return statement.execute(ctx).getResult();
    }

    private RuntimePersistentEntity ensureMeta(Class entityType) {
        return this.entities.computeIfAbsent(entityType, RuntimePersistentEntity::new);
    }

    ExecutionContext ensureExecutionContext() {
        ExecutionContext ctx = this.cohQLContext;
        if (ctx == null) {
            ctx = QueryHelper.createExecutionContext((Session)this.ensureSession());
            ctx.setExtendedLanguage(false);
            this.cohQLContext = ctx;
        }
        return ctx;
    }

    NamedMap ensureNamedMap() {
        if (this.namedMap == null) {
            this.namedMap = this.ensureSession().getMap(this.mapName, new NamedMap.Option[0]);
        }
        return this.namedMap;
    }

    protected Session ensureSession() {
        if (this.session == null) {
            this.session = (Session)this.beanContext.createBean(Session.class, new Object[]{this.sessionName == null ? "" : this.sessionName});
        }
        return this.session;
    }

    protected <T> String replaceTarget(String query, Class<? extends T> entityClass) {
        String queryLocal = query.replace("SELECT TRUE", "SELECT ");
        return queryLocal.replace(entityClass.getName(), this.getNamedMap().getName());
    }

    protected Map<String, Object> createBindingMap(PreparedQuery preparedQuery) {
        List bindings = preparedQuery.getQueryBindings();
        int bindingsLen = bindings.size();
        String[] bindingNames = new String[bindingsLen];
        Integer[] bindingIndexes = new Integer[bindingsLen];
        for (int i2 = 0; i2 < bindingsLen; ++i2) {
            QueryParameterBinding binding = (QueryParameterBinding)bindings.get(i2);
            bindingNames[i2] = binding.getName();
            bindingIndexes[i2] = binding.getParameterIndex();
        }
        Object[] bindingValues = preparedQuery.getParameterArray();
        return IntStream.range(0, bindingNames.length).boxed().collect(Collectors.toMap(i -> bindingNames[i], i -> bindingValues[bindingIndexes[i]]));
    }

    protected void logQuery(ExecutionContext ctx, Statement statement, String query, Map<String, Object> bindingParams) {
        if (LOG_QUERIES) {
            Logger.info((String)String.format("### Query: %s; parameters: %s", query, bindingParams));
            try (StringWriter sw = new StringWriter();){
                PrintWriter f = new PrintWriter((Writer)sw, true);
                statement.showPlan(f);
                f.flush();
                Logger.info((String)String.format("### Query Plan: %s", sw.getBuffer().toString()));
            }
            catch (IOException e) {
                Logger.err((String)"Error obtaining query plan", (Throwable)e);
            }
            Statement trace = QueryHelper.createStatement((String)("TRACE " + query), (ExecutionContext)ctx, bindingParams);
            Logger.info((String)trace.execute(ctx).getResult().toString());
        }
    }
}

