/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.coherence.data;

import com.oracle.coherence.repository.AbstractRepository;
import com.tangosol.net.NamedMap;
import io.micronaut.coherence.data.annotation.PersistEventSource;
import io.micronaut.coherence.data.annotation.RemoveEventSource;
import io.micronaut.coherence.data.interceptors.GetEntityTypeInterceptor;
import io.micronaut.coherence.data.interceptors.GetIdInterceptor;
import io.micronaut.coherence.data.interceptors.GetMapInterceptor;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.repository.GenericRepository;

public abstract class AbstractCoherenceRepository<T, ID>
extends AbstractRepository<ID, T>
implements GenericRepository<T, ID> {
    protected NamedMap<ID, T> getMap() {
        return this.getMapInternal();
    }

    protected ID getId(T entity) {
        return this.getIdInternal(entity);
    }

    protected Class<? extends T> getEntityType() {
        return this.getEntityTypeInternal(null);
    }

    @PersistEventSource
    public T save(T entity) {
        return (T)super.save(entity);
    }

    @RemoveEventSource
    public boolean remove(T entity) {
        return super.remove(entity);
    }

    @DataMethod(interceptor=GetIdInterceptor.class)
    protected abstract ID getIdInternal(T var1);

    @DataMethod(interceptor=GetMapInterceptor.class)
    protected abstract NamedMap<ID, T> getMapInternal();

    @DataMethod(interceptor=GetEntityTypeInterceptor.class)
    protected abstract Class<? extends T> getEntityTypeInternal(T var1);
}

