/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.coherence.data.interceptors;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.coherence.data.interceptors.AbstractEventSourceInterceptor;
import io.micronaut.data.model.runtime.EntityInstanceOperation;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.operations.async.AsyncRepositoryOperations;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public abstract class AbstractAsyncEventSourceInterceptor
extends AbstractEventSourceInterceptor {
    protected AbstractAsyncEventSourceInterceptor(RuntimeEntityRegistry registry) {
        super(registry);
    }

    @Override
    public Object intercept(MethodInvocationContext context) {
        Object[] parameters = context.getParameterValues();
        if (parameters.length == 1) {
            Object eventFor = parameters[0];
            if (eventFor instanceof EntityInstanceOperation) {
                eventFor = ((EntityInstanceOperation)eventFor).getEntity();
            }
            Object eventLocal = eventFor;
            if (!this.trigger(this.getHandledPreEventType(), eventFor)) {
                return switch (this.getEventGroup()) {
                    case AbstractEventSourceInterceptor.EventGroup.REMOVE -> {
                        if (context.getTarget() instanceof AsyncRepositoryOperations) {
                            yield CompletableFuture.completedFuture(0);
                        }
                        yield CompletableFuture.completedFuture(null);
                    }
                    default -> CompletableFuture.supplyAsync(() -> eventLocal);
                };
            }
            Object contextResult = context.proceed();
            if (contextResult != null) {
                return ((CompletionStage)contextResult).thenApplyAsync(result -> {
                    this.trigger(this.getHandledPostEventType(), eventLocal.getClass().isInstance(result) ? result : eventLocal);
                    return result;
                });
            }
            return null;
        }
        return context.proceed();
    }
}

