/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.coherence.data.ops;

import com.tangosol.coherence.dslquery.ExecutionContext;
import com.tangosol.coherence.dslquery.Statement;
import com.tangosol.coherence.dslquery.StatementResult;
import com.tangosol.net.AsyncNamedMap;
import com.tangosol.util.Processors;
import io.micronaut.coherence.data.annotation.AsyncPersistEventSource;
import io.micronaut.coherence.data.annotation.AsyncRemoveEventSource;
import io.micronaut.coherence.data.annotation.AsyncUpdateEventSource;
import io.micronaut.coherence.data.ops.CoherenceAsyncRepositoryOperations;
import io.micronaut.coherence.data.ops.DefaultCoherenceRepositoryOperations;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.exceptions.EmptyResultException;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.runtime.DeleteBatchOperation;
import io.micronaut.data.model.runtime.DeleteOperation;
import io.micronaut.data.model.runtime.InsertBatchOperation;
import io.micronaut.data.model.runtime.InsertOperation;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.UpdateOperation;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;

@Prototype
class DefaultCoherenceAsyncRepositoryOperations
implements CoherenceAsyncRepositoryOperations {
    private static final Executor SAME_THREAD_EXECUTOR = Runnable::run;
    private static final String PAGING_QUERIES_ARE_NOT_SUPPORTED = "paging queries are not supported";
    private final DefaultCoherenceRepositoryOperations repositoryOperations;
    private AsyncNamedMap asyncNamedMap;

    DefaultCoherenceAsyncRepositoryOperations(@Parameter DefaultCoherenceRepositoryOperations repositoryOperations) {
        this.repositoryOperations = repositoryOperations;
    }

    @Override
    public <ID, T> AsyncNamedMap<ID, T> getAsyncNamedMap() {
        return this.ensureAsyncMap();
    }

    @Override
    public <ID, T> ID getId(T entity) {
        return this.repositoryOperations.getId(entity);
    }

    @NonNull
    public Executor getExecutor() {
        return SAME_THREAD_EXECUTOR;
    }

    @NonNull
    public <T> CompletionStage<T> findOne(@NonNull Class<T> type, @NonNull Object id) {
        return this.findOptional(type, id).thenApply(t -> {
            if (t == null) {
                throw new EmptyResultException();
            }
            return t;
        });
    }

    @NonNull
    public <T, R> CompletionStage<R> findOne(@NonNull PreparedQuery<T, R> preparedQuery) {
        return this.findOptional(preparedQuery).thenApply(r -> {
            if (r == null) {
                throw new EmptyResultException();
            }
            return r;
        });
    }

    public <T> CompletionStage<Boolean> exists(@NonNull PreparedQuery<T, Boolean> preparedQuery) {
        return this.executeAsync(preparedQuery).thenApply(o -> !((Map)o).isEmpty());
    }

    @NonNull
    public <T> CompletionStage<T> findOptional(@NonNull Class<T> type, @NonNull Object id) {
        return this.getAsyncNamedMap().get(id);
    }

    @NonNull
    public <T, R> CompletionStage<R> findOptional(@NonNull PreparedQuery<T, R> preparedQuery) {
        CompletionStage<?> stage = this.executeAsync(preparedQuery);
        return stage.thenApply(o -> {
            if (o == null) {
                return null;
            }
            if (o instanceof Map) {
                Map m = (Map)o;
                if (m.isEmpty()) {
                    return null;
                }
                return m.values().stream().findFirst().orElse(null);
            }
            return o;
        });
    }

    @NonNull
    public <T> CompletionStage<Iterable<T>> findAll(PagedQuery<T> pagedQuery) {
        throw new UnsupportedOperationException(PAGING_QUERIES_ARE_NOT_SUPPORTED);
    }

    @NonNull
    public <T> CompletionStage<Long> count(PagedQuery<T> pagedQuery) {
        throw new UnsupportedOperationException(PAGING_QUERIES_ARE_NOT_SUPPORTED);
    }

    @NonNull
    public <T, R> CompletionStage<Iterable<R>> findAll(@NonNull PreparedQuery<T, R> preparedQuery) {
        CompletionStage<?> stage = this.executeAsync(preparedQuery);
        return stage.thenApply(o -> {
            if (o instanceof Map) {
                Map m = (Map)o;
                return m.values();
            }
            if (o instanceof Number) {
                return Collections.singletonList(((Number)o).longValue());
            }
            if (o instanceof Iterable) {
                return o;
            }
            throw new IllegalStateException("Unhandled type: " + o.getClass().getName());
        });
    }

    @NonNull
    @AsyncPersistEventSource
    public <T> CompletionStage<T> persist(@NonNull InsertOperation<T> operation) {
        Object entity = operation.getEntity();
        return this.getAsyncNamedMap().put(this.getId(entity), entity).thenApply(unused -> entity);
    }

    @NonNull
    @AsyncUpdateEventSource
    public <T> CompletionStage<T> update(@NonNull UpdateOperation<T> operation) {
        Object entity = operation.getEntity();
        return this.getAsyncNamedMap().put(this.getId(entity), entity).thenApply(unused -> entity);
    }

    @NonNull
    @AsyncRemoveEventSource
    public <T> CompletionStage<Number> delete(@NonNull DeleteOperation<T> operation) {
        Object entity = operation.getEntity();
        return this.getAsyncNamedMap().remove(this.getId(entity), entity).thenApply(aBoolean -> aBoolean != false ? 1 : 0);
    }

    @NonNull
    public <T> CompletionStage<Iterable<T>> persistAll(@NonNull InsertBatchOperation<T> operation) {
        HashMap entitiesToSave = new HashMap();
        operation.forEach(t -> entitiesToSave.put(this.getId(t), t));
        return this.getAsyncNamedMap().putAll(entitiesToSave).thenApply(unused -> entitiesToSave.values());
    }

    @NonNull
    public CompletionStage<Number> executeUpdate(@NonNull PreparedQuery<?, Number> preparedQuery) {
        CompletionStage<?> stage = this.executeAsync(preparedQuery);
        return stage.thenApply(o -> {
            if (o instanceof Map) {
                return ((Map)o).size();
            }
            if (o instanceof Set) {
                return ((Set)o).size();
            }
            throw new IllegalStateException("unhandled return type");
        });
    }

    @NonNull
    public <T> CompletionStage<Number> deleteAll(@NonNull DeleteBatchOperation<T> operation) {
        LinkedHashMap entitiesToDelete = new LinkedHashMap();
        operation.forEach(t -> entitiesToDelete.put(this.getId(t), t));
        return this.getAsyncNamedMap().invokeAll(entitiesToDelete.keySet(), Processors.remove()).thenApply(Map::size);
    }

    @NonNull
    public <R> CompletionStage<Page<R>> findPage(@NonNull PagedQuery<R> pagedQuery) {
        throw new UnsupportedOperationException(PAGING_QUERIES_ARE_NOT_SUPPORTED);
    }

    private AsyncNamedMap ensureAsyncMap() {
        if (this.asyncNamedMap == null) {
            this.asyncNamedMap = this.repositoryOperations.ensureNamedMap().async(new AsyncNamedMap.Option[0]);
        }
        return this.asyncNamedMap;
    }

    private CompletionStage<?> executeAsync(PreparedQuery preparedQuery) {
        ExecutionContext ctx = this.repositoryOperations.ensureExecutionContext();
        Statement statement = this.repositoryOperations.createStatement(ctx, preparedQuery);
        return statement.executeAsync(ctx).thenApply(StatementResult::getResult);
    }
}

