/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.coherence;

import com.tangosol.net.CacheFactory;
import com.tangosol.net.Cluster;
import com.tangosol.net.Coherence;
import com.tangosol.net.CoherenceConfiguration;
import com.tangosol.net.Session;
import com.tangosol.net.SessionConfiguration;
import com.tangosol.net.events.EventInterceptor;
import io.micronaut.coherence.SessionConfigurationProvider;
import io.micronaut.coherence.annotation.Name;
import io.micronaut.coherence.event.CoherenceEventListenerProcessor;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.context.event.StartupEvent;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.InjectionPoint;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.runtime.event.annotation.EventListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Optional;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Factory
class CoherenceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CoherenceFactory.class);
    private final BeanContext beanContext;

    @Inject
    public CoherenceFactory(BeanContext beanContext) {
        this.beanContext = beanContext;
    }

    @EventListener
    void onStartupEvent(StartupEvent event) {
        this.beanContext.getBean(Coherence.class, Qualifiers.byName((String)""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Singleton
    @Bean(preDestroy="close")
    @Named(value="")
    Coherence getCoherence(SessionConfiguration[] configurations, SessionConfigurationProvider[] providers, Coherence.LifecycleListener[] lifecycleListeners, CoherenceEventListenerProcessor listenerProcessor) {
        LOG.info("Creating default Coherence instance.");
        Coherence coherence = Coherence.getInstance((String)"");
        if (coherence == null) {
            CoherenceFactory coherenceFactory = this;
            synchronized (coherenceFactory) {
                coherence = Coherence.getInstance((String)"");
                if (coherence == null) {
                    CoherenceConfiguration cfg = CoherenceConfiguration.builder().withSessions(CoherenceFactory.collectConfigurations(configurations, providers)).withEventInterceptors((EventInterceptor[])lifecycleListeners).withEventInterceptors(listenerProcessor.getInterceptors()).build();
                    coherence = Coherence.clusterMember((CoherenceConfiguration)cfg);
                }
            }
        }
        coherence.start().join();
        return coherence;
    }

    @Prototype
    Session getSession(@Nullable InjectionPoint<?> injectionPoint, @Parameter @Nullable String name) {
        String sessionName = injectionPoint != null ? injectionPoint.findAnnotation(Name.class).flatMap(value -> value.getValue(String.class)).orElse("") : (StringUtils.isNotEmpty((CharSequence)name) ? name : "");
        this.beanContext.getBean(Coherence.class, Qualifiers.byName((String)""));
        return (Session)Coherence.findSession((String)sessionName).orElseThrow(() -> new IllegalStateException("No Session has been configured with the name " + sessionName));
    }

    @Prototype
    Cluster getCluster() {
        return CacheFactory.getCluster();
    }

    static Collection<SessionConfiguration> collectConfigurations(SessionConfiguration[] configurations, SessionConfigurationProvider[] providers) {
        ArrayList<SessionConfiguration> allConfigs = new ArrayList<SessionConfiguration>(Arrays.asList(configurations));
        Arrays.stream(providers).map(SessionConfigurationProvider::getConfiguration).filter(Optional::isPresent).map(Optional::get).forEach(allConfigs::add);
        allConfigs.sort(Comparator.reverseOrder());
        HashMap<String, SessionConfiguration> configMap = new HashMap<String, SessionConfiguration>();
        for (SessionConfiguration cfg : allConfigs) {
            String name;
            if (cfg == null || !cfg.isEnabled() || configMap.containsKey(name = cfg.getName())) continue;
            configMap.put(name, cfg);
        }
        return configMap.values();
    }

    @PreDestroy
    public void shutdownCoherence(ApplicationContext ctx) {
        Boolean cleanUp = ctx.getEnvironment().getProperty("coherence.micronaut.autoCleanup", Boolean.class).orElse(Boolean.TRUE);
        if (cleanUp.booleanValue()) {
            LOG.info("Stopping Coherence");
            Coherence.closeAll();
            LOG.info("Stopped Coherence");
        }
    }
}

